/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.forms.common.rendering.client.widgets.picture.widget;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;

@Dependent
public class PictureWidget implements IsWidget {

    private PictureWidgetView view;

    @Inject
    public PictureWidget(PictureWidgetView view) {
        this.view = view;
    }

    @Override
    public Widget asWidget() {
        return view.asWidget();
    }

    public void init(int width,
                     int height,
                     TakePictureCallback callback) {
        view.init(width,
                  height,
                  callback);
    }

    public void setPictureUrl(String url) {
        view.setPictureUrl(url);
    }

    public void setReadOnly(boolean readOnly) {
        view.setReadOnly(readOnly);
    }

    public interface TakePictureCallback {

        public void onTakePicture(String url);
    }

    public enum WidgetMode {
        PICTURE,
        READONLY
    }
}
