/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.image.provider;

import javax.enterprise.context.Dependent;

import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.BasicTypeFieldProvider;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.image.definition.PictureFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.image.type.PictureFieldType;
import org.kie.workbench.common.forms.model.FieldDataType;

@Dependent
public class PictureFieldProvider extends BasicTypeFieldProvider<PictureFieldDefinition> {

    @Override
    public Class<PictureFieldType> getFieldType() {
        return PictureFieldType.class;
    }

    @Override
    public String getFieldTypeName() {
        return PictureFieldType.NAME;
    }

    @Override
    protected void doRegisterFields() {
        registerPropertyType(String.class);
    }

    @Override
    public int getPriority() {
        return 9;
    }

    @Override
    public PictureFieldDefinition createFieldByType(FieldDataType typeInfo) {
        return getDefaultField();
    }

    @Override
    public PictureFieldDefinition getDefaultField() {
        return new PictureFieldDefinition();
    }
}
