/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.bpmn.definition.property.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentsInfo;
import org.kie.workbench.common.stunner.core.util.EqualsAndHashCodeTestUtils;

public class ReassignmentsInfoTest {

    @Test
    public void testEqualsAndHashCode() {
        EqualsAndHashCodeTestUtils.TestCaseBuilder.newTestCase()
                .addTrueCase(new ReassignmentsInfo(),
                        new ReassignmentsInfo())
                .addTrueCase(new ReassignmentsInfo(new ReassignmentTypeListValue()),
                        new ReassignmentsInfo(new ReassignmentTypeListValue()))
                .addTrueCase(new ReassignmentsInfo(),
                        new ReassignmentsInfo(new ReassignmentTypeListValue()))
                .test();
    }

    private List<ReassignmentValue> getReassignmentValues(){
        List<ReassignmentValue> result = new ArrayList<>();
        result.add(new ReassignmentValue("AAA",
                "1h",
                Arrays.asList(new String[]{"foo", "bar", "baz"}),
                Arrays.asList(new String[]{"foo", "bar", "baz"})));
        return result;
    }
}
