/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.core.client.shape.view.event;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

@RunWith(MockitoJUnitRunner.class)
public class DragContextTest {

    private static final int DX = 10;
    private static final int DY = 100;

    @Mock
    private Command resetCommand;

    private DragContext tested;

    @Before
    public void setup() throws Exception {
        tested = new DragContext(DX,
                                 DY,
                                 resetCommand);
    }

    @Test
    public void test() {
        tested.reset();
        verify(resetCommand,
               times(1)).execute();
        assertEquals(DX,
                     tested.getDx());
        assertEquals(DY,
                     tested.getDy());
    }
}
