/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.cm.client.shape.view.handler;

import org.kie.workbench.common.stunner.cm.definition.UserTask;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeViewHandler;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGViewUtils;

public class TaskViewHandler implements ShapeViewHandler<UserTask, SVGShapeView<?>> {

    static final String MULTIPLE_INSTANCE_ICON_PARALLEL = "userTaskMIIMultipleInstanceIconParallel";
    static final String MULTIPLE_INSTANCE_ICON_SEQUENTIAL = "userTaskMIIMultipleInstanceIconSequential";

    @Override
    public void handle(UserTask userTask, SVGShapeView<?> view) {
        final boolean multipleInstance = userTask.getExecutionSet().getIsMultipleInstance().getValue();
        final boolean sequential = userTask.getExecutionSet().getMultipleInstanceExecutionMode().isSequential();

        SVGViewUtils.setFillAndStroke(view, MULTIPLE_INSTANCE_ICON_PARALLEL, 0, 0);
        SVGViewUtils.setFillAndStroke(view, MULTIPLE_INSTANCE_ICON_SEQUENTIAL, 0, 0);

        if (multipleInstance) {
            if (sequential) {
                SVGViewUtils.setFillAndStroke(view, MULTIPLE_INSTANCE_ICON_SEQUENTIAL, 1, 1);
            } else {
                SVGViewUtils.setFillAndStroke(view, MULTIPLE_INSTANCE_ICON_PARALLEL, 1, 1);
            }
        }
    }
}
