/*
 * Copyright 2012 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.workbench.common.services.backend.builder.core;

import org.guvnor.common.services.builder.ResourceChangeObservableFile;
import org.uberfire.backend.vfs.Path;

/**
 * Changes to kmodule.xml invalidates the DMO cache
 */
public class ObservableKModuleFile implements ResourceChangeObservableFile {

    static final String FILENAME = "kmodule.xml";

    @Override
    public boolean accept(final Path path) {
        final String fileName = path.getFileName();
        return fileName.equals(FILENAME);
    }
}
