/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.dmn.showcase.client.large.model;

import org.junit.Test;
import org.kie.workbench.common.dmn.showcase.client.common.DMNDesignerBaseIT;
import org.kie.workbench.common.dmn.showcase.client.selenium.locator.DecisionNavigatorXPathLocator;
import org.kie.workbench.common.dmn.showcase.client.selenium.locator.EditorXPathLocator;

import static org.assertj.core.api.Assertions.assertThat;

public class DMNDesignerLargeAssetIT extends DMNDesignerBaseIT {

    @Test
    public void testCopiesOfTheSameNode() throws Exception {
        final String expected = loadResource("large-model-nodes-226-copies.xml");
        setContent(expected);

        final String actual = getContent();
        assertThat(actual).isNotBlank();

        decisionNavigator.assertItemIsPresent(DecisionNavigatorXPathLocator.node("Decision-1"));
    }

    @Test
    public void testUniqueNodesWithoutLayout() throws Exception {
        final String expected = loadResource("large-model-nodes-50-unique-no-layout.xml");
        setContent(expected);

        waitUtils.waitUntilElementIsVisible(
                EditorXPathLocator.missingLayoutPopUpCloseButton(),
                "Editor should inform about missing layout information")
                .click();

        final String actual = getContent();
        assertThat(actual).isNotBlank();



        for (int i = 1; i <= 50; i++) {
            decisionNavigator.assertItemIsPresent(DecisionNavigatorXPathLocator.node("Decision " + i));
        }
    }
}
