/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.dmn.client.widgets.grid.model;

import java.util.ArrayList;
import java.util.List;

import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;

public class DMNGridColumn<T> extends BaseGridColumn<T> {

    public static final double PADDING = 0.0;

    public static final double DEFAULT_WIDTH = 100.0;

    protected final GridWidget gridWidget;

    public DMNGridColumn(final HeaderMetaData headerMetaData,
                         final GridColumnRenderer<T> columnRenderer,
                         final GridWidget gridWidget) {
        this(new ArrayList<HeaderMetaData>() {{
                 add(headerMetaData);
             }},
             columnRenderer,
             gridWidget);
    }

    public DMNGridColumn(final List<HeaderMetaData> headerMetaData,
                         final GridColumnRenderer<T> columnRenderer,
                         final GridWidget gridWidget) {
        super(headerMetaData,
              columnRenderer,
              DEFAULT_WIDTH);
        this.gridWidget = gridWidget;
    }

    public void setWidthInternal(final double width) {
        super.setWidth(width);
    }

    public void updateWidthOfPeers() {
        if (gridWidget instanceof BaseExpressionGrid) {
            final int parentColumnIndex = ((BaseExpressionGrid) gridWidget).getParentInformation().getColumnIndex();
            final GridData gridData = ((BaseExpressionGrid) gridWidget).getParentInformation().getGridData();
            if (gridData != null) {
                final GridColumn<?> parentColumn = gridData.getColumns().get(parentColumnIndex);
                parentColumn.setWidth(gridWidget.getWidth() + PADDING * 2);
            }
        }
    }
}
