/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.screens.library.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public class LibraryConstants {

    @TranslationKey(defaultValue = "")
    public static final String NewProject = "NewProject";

    @TranslationKey(defaultValue = "")
    public static final String ProjectCreated = "ProjectCreated";

    @TranslationKey(defaultValue = "")
    public static final String Settings = "Settings";

    @TranslationKey(defaultValue = "")
    public static final String ProjectImportedSuccessfully = "ProjectImportedSuccessfully";

    @TranslationKey(defaultValue = "")
    public static final String ProjectImportError = "ProjectImportError";

    @TranslationKey(defaultValue = "")
    public static final String Importing = "Importing";

    @TranslationKey(defaultValue = "")
    public static final String LoadingAssets = "LoadingAssets";

    @TranslationKey(defaultValue = "")
    public static final String LastModified = "LastModified";

    @TranslationKey(defaultValue = "")
    public static final String Created = "Created";

    @TranslationKey(defaultValue = "")
    public static final String DefaultProject = "DefaultProject";

    @TranslationKey(defaultValue = "")
    public static final String QuickSetup = "QuickSetup";

    @TranslationKey(defaultValue = "")
    public static final String AdvancedSetup = "AdvancedSetup";

    @TranslationKey(defaultValue = "")
    public static final String OtherProjects = "OtherProjects";

    @TranslationKey(defaultValue = "")
    public static final String ProjectDeleted = "ProjectDeleted";

    @TranslationKey(defaultValue = "")
    public static final String ABuildIsAlreadyRunning = "ABuildIsAlreadyRunning";

    @TranslationKey(defaultValue = "")
    public static final String FilterByName = "FilterByName";

    @TranslationKey(defaultValue = "")
    public static final String CreateOrganizationalUnit = "CreateOrganizationalUnit";

    @TranslationKey(defaultValue = "")
    public static final String Save = "Save";

    @TranslationKey(defaultValue = "")
    public static final String Cancel = "Cancel";

    @TranslationKey(defaultValue = "")
    public static final String DeleteOrganizationalUnitSuccess = "DeleteOrganizationalUnitSuccess";

    @TranslationKey(defaultValue = "")
    public static final String EmptyFieldValidation = "EmptyFieldValidation";

    @TranslationKey(defaultValue = "")
    public static final String DuplicatedOrganizationalUnitValidation = "DuplicatedOrganizationalUnitValidation";

    @TranslationKey(defaultValue = "")
    public static final String InvalidFieldValidation = "InvalidFieldValidation";

    @TranslationKey(defaultValue = "")
    public static final String Saving = "Saving";

    @TranslationKey(defaultValue = "")
    public static final String OrganizationalUnitSaveSuccess = "OrganizationalUnitSaveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String Name = "Name";

    @TranslationKey(defaultValue = "")
    public static final String DefaultGroupId = "DefaultGroupId";

    @TranslationKey(defaultValue = "")
    public static final String Repositories = "Repositories";

    @TranslationKey(defaultValue = "")
    public static final String OrganizationalUnitDefaultAliasInSingular = "OrganizationalUnitDefaultAliasInSingular";

    @TranslationKey(defaultValue = "")
    public static final String OrganizationalUnitDefaultAliasInPlural = "OrganizationalUnitDefaultAliasInPlural";

    @TranslationKey(defaultValue = "")
    public static final String IndexingHasNotFinished = "IndexingHasNotFinished";

    @TranslationKey(defaultValue = "")
    public static final String PleaseWaitWhileTheProjectContentIsBeingIndexed = "PleaseWaitWhileTheProjectContentIsBeingIndexed";

    @TranslationKey(defaultValue = "")
    public static final String EmptySearch = "EmptySearch";

    @TranslationKey(defaultValue = "")
    public static final String NoFilesWhereFoundWithTheGivenSearchCriteria = "NoFilesWhereFoundWithTheGivenSearchCriteria";

    @TranslationKey(defaultValue = "")
    public static final String EndOfFileList = "EndOfFileList";

    @TranslationKey(defaultValue = "")
    public static final String NoMoreFilesPleasePressPrevious = "NoMoreFilesPleasePressPrevious";

    @TranslationKey(defaultValue = "")
    public static final String Preferences = "Preferences";

    @TranslationKey(defaultValue = "")
    public static final String AdvancedImport = "AdvancedImport";

    @TranslationKey(defaultValue = "")
    public static final String ImportProjects = "ImportProjects";

    @TranslationKey(defaultValue = "")
    public static final String ImportExamples = "ImportExamples";

    @TranslationKey(defaultValue = "")
    public static final String DuplicatedProjectValidation = "DuplicatedProjectValidation";

    @TranslationKey(defaultValue = "")
    public static final String OrgUnitsMetrics = "OrgUnitsMetrics";

    @TranslationKey(defaultValue = "")
    public static final String PerOrgUnit = "PerOrgUnit";

    @TranslationKey(defaultValue = "")
    public static final String ProjectMetrics = "ProjectMetrics";

    @TranslationKey(defaultValue = "")
    public static final String Metrics = "Metrics";

    @TranslationKey(defaultValue = "")
    public static final String Date = "Date";

    @TranslationKey(defaultValue = "")
    public static final String Years = "Years";

    @TranslationKey(defaultValue = "")
    public static final String Quarters = "Quarters";

    @TranslationKey(defaultValue = "")
    public static final String DayOfWeek = "DayOfWeek";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfCommits = "NumberOfCommits";

    @TranslationKey(defaultValue = "")
    public static final String Projects = "Projects";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfProjects = "NumberOfProjects";

    @TranslationKey(defaultValue = "")
    public static final String Project = "Project";

    @TranslationKey(defaultValue = "")
    public static final String Author = "Author";

    @TranslationKey(defaultValue = "")
    public static final String Message = "Message";

    @TranslationKey(defaultValue = "")
    public static final String TopContributor = "TopContributor";

    @TranslationKey(defaultValue = "")
    public static final String NotEnoughPermissionsToAccessLibrary = "NotEnoughPermissionsToAccessLibrary";

    @TranslationKey(defaultValue = "")
    public static final String Search = "Search";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfContributors = "NumberOfContributors";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfRepositories = "NumberOfRepositories";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfAssets = "NumberOfAssets";

    @TranslationKey(defaultValue = "")
    public static final String WrongOrganizationalUnitConfirmedName = "WrongOrganizationalUnitConfirmedName";

    @TranslationKey(defaultValue = "")
    public static final String DeletingOrganizationalUnit = "DeletingOrganizationalUnit";

    @TranslationKey(defaultValue = "")
    public static final String DeleteOrganizationalUnit = "DeleteOrganizationalUnit";

    @TranslationKey(defaultValue = "")
    public static final String DeleteOrganizationalUnitDescription = "DeleteOrganizationalUnitDescription";

    @TranslationKey(defaultValue = "")
    public static final String ConfirmOrganizationalUnitName = "ConfirmOrganizationalUnitName";

    @TranslationKey(defaultValue = "")
    public static final String EditOrganizationalUnitContributors = "EditOrganizationalUnitContributors";

    @TranslationKey(defaultValue = "")
    public static final String EditOrganizationalUnitContributorsSaveSuccess = "EditOrganizationalUnitContributorsSaveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String Add = "Add";

    @TranslationKey(defaultValue = "")
    public static final String AddProject = "AddProject";

    @TranslationKey(defaultValue = "")
    public static final String AddProjectSuccess = "AddProjectSuccess";

    @TranslationKey(defaultValue = "")
    public static final String ShowAdvancedOptions = "ShowAdvancedOptions";

    @TranslationKey(defaultValue = "")
    public static final String HideAdvancedOptions = "HideAdvancedOptions";

    @TranslationKey(defaultValue = "")
    public static final String GroupId = "GroupId";

    @TranslationKey(defaultValue = "")
    public static final String ArtifactId = "ArtifactId";

    @TranslationKey(defaultValue = "")
    public static final String Version = "Version";

    @TranslationKey(defaultValue = "")
    public static final String ImportProject = "ImportProject";

    @TranslationKey(defaultValue = "")
    public static final String Import = "Import";

    @TranslationKey(defaultValue = "")
    public static final String TrySamples = "TrySamples";

    @TranslationKey(defaultValue = "")
    public static final String Owner = "Owner";

    @TranslationKey(defaultValue = "")
    public static final String Contributor = "Contributor";

    @TranslationKey(defaultValue = "")
    public static final String NoProjectsToImport = "NoProjectsToImport";

    @TranslationKey(defaultValue = "")
    public static final String Loading = "Loading";

    @TranslationKey(defaultValue = "")
    public static final String NoProjectsSelected = "NoProjectsSelected";

    @TranslationKey(defaultValue = "")
    public static final String ImportProjectsSuccess = "ImportProjectsSuccess";

    @TranslationKey(defaultValue = "")
    public static final String NoOrganizationalUnits = "NoOrganizationalUnits";

    @TranslationKey(defaultValue = "")
    public static final String RepositoryURL = "RepositoryURL";
}
