/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.core.client.command;

import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.DefaultCanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.BoundingBox;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ViewTraverseProcessor;

public class CanvasCommandFactoryStub extends DefaultCanvasCommandFactory {

    public CanvasCommandFactoryStub() {
        this(null, null);
    }

    public CanvasCommandFactoryStub(ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessors,
                                    ManagedInstance<ViewTraverseProcessor> viewTraverseProcessors) {
        super(childrenTraverseProcessors, viewTraverseProcessors);
    }

    @Override
    public CanvasCommand<AbstractCanvasHandler> resize(Element<? extends View<?>> element, BoundingBox boundingBox) {
        return null;
    }
}
