/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.core.client.shape.view;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.ShapeViewExtStub;
import org.kie.workbench.common.stunner.core.client.shape.view.handler.CompositeShapeViewHandler;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import static org.mockito.Matchers.anyString;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

@RunWith(MockitoJUnitRunner.class)
public class CompositeShapeViewHandlerTest {

    @Mock
    private ShapeViewHandler<Object, ShapeViewExtStub> handler1;

    @Mock
    private ShapeViewHandler<Object, ShapeViewExtStub> handler2;

    private CompositeShapeViewHandler<Object, ShapeViewExtStub> tested;
    private ShapeViewExtStub view;

    @Before
    @SuppressWarnings("unchecked")
    public void setup() throws Exception {
        view = spy(new ShapeViewExtStub());
        tested = new CompositeShapeViewHandler<Object, ShapeViewExtStub>()
                .register(handler1)
                .register(handler2);
    }

    @Test
    public void testHandle() {
        final Object bean = mock(Object.class);
        tested.handle(bean, view);
        verify(handler1, times(1)).handle(eq(bean),
                                          eq(view));
        verify(handler2, times(1)).handle(eq(bean),
                                          eq(view));
    }

    @Test
    public void testHandleNoTitle() {
        tested.handle(null, view);
        verify(view, never()).setTitle(anyString());
    }
}
