/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.Main;
import org.osgi.framework.Bundle;

public class ClassPatcherWrappers {
    protected static BundleClassLoader getBundleClassLoader(long bid) {
        BundleImpl b = (BundleImpl)Main.framework.getSystemBundleContext().getBundle(bid);
        if (b != null) {
            return (BundleClassLoader)b.getClassLoader();
        }
        return null;
    }

    public static void systemExitWrapper(int code, long bid, Object context) {
        System.out.println("CP.systemExit code=" + code + ", bid=" + bid + ", context=" + context);
        try {
            Bundle b = Main.framework.getSystemBundleContext().getBundle(bid);
            System.out.println("stopping " + b);
            b.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ClassLoader getSystemClassLoaderWrapper(long bid, Object context) {
        BundleClassLoader bcl = ClassPatcherWrappers.getBundleClassLoader(bid);
        if (bcl == null) {
            throw new IllegalStateException("Undefined bid=" + bid);
        }
        return bcl;
    }

    public static Class forName1Wrapper(String name, long bid, Object context) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            try {
                if (context != null) {
                    context.getClass();
                    return Class.forName(name);
                }
            }
            catch (ClassNotFoundException keeptrying) {
                // empty catch block
            }
            BundleClassLoader bcl = ClassPatcherWrappers.getBundleClassLoader(bid);
            if (bcl == null) {
                throw new ClassNotFoundException("Undefined class '" + name + "' since bid=" + bid + " is undefined");
            }
            return bcl.loadClass(name, true);
        }
    }

    public static Class forName3Wrapper(String name, boolean initialize, ClassLoader cl, long bid, Object context) throws ClassNotFoundException {
        try {
            return Class.forName(name, initialize, cl);
        }
        catch (ClassNotFoundException e) {
            try {
                if (context != null) {
                    return Class.forName(name, initialize, context.getClass().getClassLoader());
                }
            }
            catch (ClassNotFoundException keeptrying) {
                // empty catch block
            }
            BundleClassLoader bcl = ClassPatcherWrappers.getBundleClassLoader(bid);
            if (bcl == null) {
                throw new ClassNotFoundException("Undefined class '" + name + "' since bid=" + bid + " is undefined");
            }
            return bcl.loadClass(name, true);
        }
    }
}

