/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ExportedPackageImpl;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.Packages;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.RequiredBundleImpl;
import org.knopflerfish.framework.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    static final String SPEC_VERSION = "1.2";
    private Framework framework;

    PackageAdminImpl(Framework fw) {
        this.framework = fw;
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        int size;
        ArrayList<ExportedPackageImpl> pkgs = new ArrayList<ExportedPackageImpl>();
        if (bundle != null) {
            Iterator i = ((BundleImpl)bundle).getExports();
            while (i.hasNext()) {
                pkgs.add(new ExportedPackageImpl((ExportPkg)i.next()));
            }
        } else {
            Iterator bi = this.framework.bundles.getBundles().iterator();
            while (bi.hasNext()) {
                Iterator i = ((BundleImpl)bi.next()).getExports();
                while (i.hasNext()) {
                    pkgs.add(new ExportedPackageImpl((ExportPkg)i.next()));
                }
            }
        }
        if ((size = pkgs.size()) > 0) {
            return pkgs.toArray(new ExportedPackage[size]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(String name) {
        Pkg pkg = this.framework.packages.getPkg(name);
        ExportedPackage[] res = null;
        if (pkg != null) {
            Pkg pkg2 = pkg;
            synchronized (pkg2) {
                int size = pkg.exporters.size();
                if (size > 0) {
                    res = new ExportedPackage[size];
                    Iterator i = ((AbstractList)pkg.exporters).iterator();
                    int pos = 0;
                    while (pos < size) {
                        res[pos++] = new ExportedPackageImpl((ExportPkg)i.next());
                    }
                }
            }
        }
        return res;
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportPkg ep;
        Pkg p = this.framework.packages.getPkg(name);
        if (p != null && (ep = p.getBestProvider()) != null) {
            return new ExportedPackageImpl(ep);
        }
        return null;
    }

    public void refreshPackages(final Bundle[] bundles) {
        this.framework.perm.checkResolveAdminPerm();
        boolean restart = false;
        if (bundles != null) {
            for (int i = 0; i < bundles.length; ++i) {
                if (bundles[i] == null) {
                    throw new NullPointerException("bundle[" + i + "] cannot be null");
                }
                if (!((BundleImpl)bundles[i]).extensionNeedsRestart()) continue;
                restart = true;
                break;
            }
        } else {
            Iterator iter = this.framework.bundles.getBundles().iterator();
            while (iter.hasNext()) {
                if (!((BundleImpl)iter.next()).extensionNeedsRestart()) continue;
                restart = true;
                break;
            }
        }
        if (restart) {
            try {
                this.framework.systemBundle.stop(200);
            }
            catch (BundleException ignored) {
                // empty catch block
            }
            return;
        }
        final PackageAdminImpl thisClass = this;
        Thread t = new Thread(){

            public void run() {
                ((PackageAdminImpl)PackageAdminImpl.this).framework.perm.callRefreshPackages0(thisClass, bundles);
            }
        };
        t.setDaemon(false);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshPackages0(Bundle[] bundles) {
        if (Debug.packages) {
            Debug.println("PackageAdminImpl.refreshPackages() starting");
        }
        BundleImpl[] bi = this.framework.packages.getZombieAffected(bundles).toArray(new BundleImpl[0]);
        ArrayList<BundleImpl> startList = new ArrayList<BundleImpl>();
        int bx = bi.length;
        while (bx-- > 0) {
            BundleException be = null;
            BundleImpl bundleImpl = bi[bx];
            synchronized (bundleImpl) {
                if (bi[bx].state == 32) {
                    startList.add(0, bi[bx]);
                    be = bi[bx].stop0(false);
                }
            }
            if (be == null) continue;
            this.framework.listeners.frameworkError(bi[bx], be);
        }
        Packages packages = this.framework.packages;
        synchronized (packages) {
            bi = this.framework.packages.getZombieAffected(bundles).toArray(new BundleImpl[0]);
            int startPos = startList.size() - 1;
            BundleImpl nextStart = startPos >= 0 ? (BundleImpl)startList.get(startPos) : null;
            int bx2 = bi.length;
            while (bx2-- > 0) {
                BundleException be = null;
                BundleImpl bundleImpl = bi[bx2];
                synchronized (bundleImpl) {
                    switch (bi[bx2].state) {
                        case 8: 
                        case 32: {
                            BundleImpl bundleImpl2 = bi[bx2];
                            synchronized (bundleImpl2) {
                                if (bi[bx2].state == 32) {
                                    be = bi[bx2].stop0(false);
                                    if (nextStart != bi[bx2]) {
                                        startList.add(startPos + 1, bi[bx2]);
                                    }
                                }
                            }
                        }
                        case 4: 
                        case 16: {
                            bi[bx2].setStateInstalled(true);
                            if (bi[bx2] != nextStart) break;
                            nextStart = --startPos >= 0 ? (BundleImpl)startList.get(startPos) : null;
                        }
                    }
                    bi[bx2].purge();
                }
                if (be == null) continue;
                this.framework.listeners.frameworkError(bi[bx2], be);
            }
        }
        if (Debug.packages) {
            Debug.println("PackageAdminImpl.refreshPackages() all affected bundles now in state INSTALLED");
        }
        this.framework.bundles.startBundles(startList);
        this.framework.listeners.frameworkEvent(new FrameworkEvent(4, this));
        if (Debug.packages) {
            Debug.println("PackageAdminImpl.refreshPackages() done.");
        }
    }

    public boolean resolveBundles(Bundle[] bundles) {
        List<Bundle> bl;
        this.framework.perm.checkResolveAdminPerm();
        if (bundles != null) {
            bl = new ArrayList();
            for (int bx = 0; bx < bundles.length; ++bx) {
                bl.add(bundles[bx]);
            }
        } else {
            bl = this.framework.bundles.getBundles();
        }
        boolean res = true;
        Iterator i = bl.iterator();
        while (i.hasNext()) {
            BundleImpl b = (BundleImpl)i.next();
            if (b.getUpdatedState() != 2) continue;
            res = false;
        }
        return res;
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        ArrayList<RequiredBundleImpl> res = new ArrayList<RequiredBundleImpl>();
        List bs = symbolicName != null ? this.framework.bundles.getBundles(symbolicName) : this.framework.bundles.getBundles();
        Iterator i = bs.iterator();
        while (i.hasNext()) {
            BundleImpl b = (BundleImpl)i.next();
            if ((b.state & BundleImpl.RESOLVED_FLAGS) == 0 && b.getRequiredBy().size() <= 0 || b.isFragment()) continue;
            res.add(new RequiredBundleImpl(b.bpkgs));
        }
        int s = res.size();
        if (s > 0) {
            return res.toArray(new RequiredBundle[s]);
        }
        return null;
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        VersionRange vr = versionRange != null ? new VersionRange(versionRange.trim()) : VersionRange.defaultVersionRange;
        List bs = this.framework.bundles.getBundles(symbolicName, vr);
        int size = bs.size();
        if (size > 0) {
            Bundle[] res = new Bundle[size];
            Iterator i = bs.iterator();
            int pos = 0;
            while (pos < size) {
                res[pos++] = (Bundle)i.next();
            }
            return res;
        }
        return null;
    }

    public Bundle[] getFragments(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        BundleImpl b = (BundleImpl)bundle;
        if (b.isFragment()) {
            return null;
        }
        if (b.isFragmentHost()) {
            return b.fragments.toArray(new Bundle[0]);
        }
        return null;
    }

    public Bundle[] getHosts(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        BundleImpl b = (BundleImpl)bundle;
        if (b.isFragment() && b.isAttached()) {
            return new Bundle[]{b.getFragmentHost()};
        }
        return null;
    }

    public Bundle getBundle(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleClassLoader) {
            return ((BundleClassLoader)cl).getBundle();
        }
        return null;
    }

    public int getBundleType(Bundle bundle) {
        BundleImpl b = (BundleImpl)bundle;
        if (b.isFragment() && !b.isExtension()) {
            return 1;
        }
        return 0;
    }
}

