/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.Enumeration;

class PropertiesDictionary
extends Dictionary {
    private String[] keys;
    private Object[] values;
    private int size;
    private int ocIndex = -1;
    private int sidIndex = -1;
    private static long nextServiceID = 1L;

    PropertiesDictionary(Dictionary in) {
        int max_size = in != null ? in.size() + 2 : 2;
        this.keys = new String[max_size];
        this.values = new Object[max_size];
        this.size = 0;
        if (in != null) {
            try {
                Enumeration e = in.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (this.ocIndex == -1 && key.equalsIgnoreCase("objectClass")) {
                        this.ocIndex = this.size;
                    } else if (this.sidIndex == -1 && key.equalsIgnoreCase("service.id")) {
                        this.sidIndex = this.size;
                    } else {
                        for (int i = this.size - 1; i >= 0; --i) {
                            if (!key.equalsIgnoreCase(this.keys[i])) continue;
                            throw new IllegalArgumentException("Several entries for property: " + key);
                        }
                    }
                    this.keys[this.size] = key;
                    this.values[this.size++] = in.get(key);
                }
            }
            catch (ClassCastException ignore) {
                throw new IllegalArgumentException("Properties contains key that is not of type java.lang.String");
            }
        }
    }

    PropertiesDictionary(Dictionary in, String[] classes, Long sid) {
        this(in);
        Long l;
        if (this.ocIndex == -1) {
            this.keys[this.size] = "objectClass";
            this.ocIndex = this.size++;
        }
        this.values[this.ocIndex] = classes;
        if (this.sidIndex == -1) {
            this.keys[this.size] = "service.id";
            this.sidIndex = this.size++;
        }
        if (sid != null) {
            l = sid;
        } else {
            long l2 = nextServiceID++;
            l = new Long(l2);
        }
        this.values[this.sidIndex] = l;
    }

    public Object get(Object key) {
        if (key == "objectClass") {
            return this.ocIndex >= 0 ? this.values[this.ocIndex] : null;
        }
        if (key == "service.id") {
            return this.sidIndex >= 0 ? this.values[this.sidIndex] : null;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!((String)key).equalsIgnoreCase(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public String[] keyArray() {
        if (this.keys.length != this.size) {
            String[] nkeys = new String[this.size];
            System.arraycopy(this.keys, 0, nkeys, 0, this.size);
            this.keys = nkeys;
        }
        return (String[])this.keys.clone();
    }

    public int size() {
        return this.size;
    }

    public Enumeration elements() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Enumeration keys() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Object put(Object k, Object v) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Object remove(Object k) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

