/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SearchResult;

public class GHIssueSearchBuilder
extends GHSearchBuilder<GHIssue> {
    GHIssueSearchBuilder(GitHub root) {
        super(root, IssueSearchResult.class);
    }

    public GHIssueSearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    public GHIssueSearchBuilder mentions(GHUser u) {
        return this.mentions(u.getLogin());
    }

    public GHIssueSearchBuilder mentions(String login) {
        return this.q("mentions:" + login);
    }

    public GHIssueSearchBuilder isOpen() {
        return this.q("is:open");
    }

    public GHIssueSearchBuilder isClosed() {
        return this.q("is:closed");
    }

    public GHIssueSearchBuilder isMerged() {
        return this.q("is:merged");
    }

    public GHIssueSearchBuilder order(GHDirection v) {
        this.req.with("order", v);
        return this;
    }

    public GHIssueSearchBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    @Override
    protected String getApiUrl() {
        return "/search/issues";
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
    private static class IssueSearchResult
    extends SearchResult<GHIssue> {
        private GHIssue[] items;

        private IssueSearchResult() {
        }

        GHIssue[] getItems(GitHub root) {
            for (GHIssue gHIssue : this.items) {
            }
            return this.items;
        }
    }

    public static enum Sort {
        COMMENTS,
        CREATED,
        UPDATED;

    }
}

