/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.mvel.MVEL;
import org.mvel.TemplateInterpreter;
import org.mvel.integration.impl.LocalVariableResolverFactory;

public class MVELSH {
    public static void main(String[] args) {
        HashMap map = new HashMap();
        boolean output = true;
        boolean stacktrace = false;
        boolean showExecTime = false;
        boolean benchmarkMode = false;
        boolean template = false;
        LocalVariableResolverFactory lvrf = new LocalVariableResolverFactory(new HashMap<String, Object>());
        Object out = null;
        while (true) {
            try {
                while (true) {
                    long time;
                    System.out.print("mvel$ ");
                    String in = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    if (in.length() == 0) continue;
                    if ("quit;".equals(in) || "exit;".equals(in)) {
                        return;
                    }
                    if ("stacktrace;".equals(in)) {
                        stacktrace = !stacktrace;
                        System.out.println("STACKTRACES: " + (stacktrace ? "ON" : "OFF"));
                        continue;
                    }
                    if ("echo;".equals(in)) {
                        output = !output;
                        System.out.println("OUTPUT ECHO: " + (output ? "ON" : "OFF"));
                        continue;
                    }
                    if ("template;".equals(in)) {
                        template = !template;
                        System.out.println("TEMPLATE INTERPRETER: " + (template ? "ON" : "OFF"));
                        continue;
                    }
                    if ("exectime;".equals(in)) {
                        showExecTime = !showExecTime;
                        System.out.println("SHOW EXEC TIME: " + (showExecTime ? "ON " : "OFF"));
                        continue;
                    }
                    if ("benchmark;".equals(in)) {
                        benchmarkMode = !benchmarkMode;
                        showExecTime = true;
                        System.out.println("MVELSH BENCHMARK MODE: " + (benchmarkMode ? "ON" : "OFF"));
                        continue;
                    }
                    if ("clear;".equals(in)) {
                        map.clear();
                        System.out.println("CLEARED VARIABLES.");
                        continue;
                    }
                    if ("help;".equals(in)) {
                        MVELSH.showHelp();
                        continue;
                    }
                    if (template) {
                        time = System.currentTimeMillis();
                        out = TemplateInterpreter.parse(in, null, map);
                        time = System.currentTimeMillis() - time;
                    } else if (benchmarkMode) {
                        System.out.println("HOTSPOT WARMUP ...");
                        int i = 10000;
                        while (i != 0) {
                            MVEL.eval(in, lvrf);
                            --i;
                        }
                        System.out.println("RUNNING BENCHMARK (10,000 times) ...");
                        time = System.currentTimeMillis();
                        i = 10000;
                        while (i != 0) {
                            out = MVEL.eval(in, lvrf);
                            --i;
                        }
                        time = System.currentTimeMillis() - time;
                    } else {
                        time = System.currentTimeMillis();
                        out = MVEL.eval(in, lvrf);
                        time = System.currentTimeMillis() - time;
                    }
                    if (showExecTime) {
                        System.out.println("DONE in : " + time + "ms.");
                    }
                    if (!output) continue;
                    System.out.println(String.valueOf(template ? "TOUT: " : "OUT: ") + out);
                }
            }
            catch (Exception e) {
                if (stacktrace) {
                    e.printStackTrace();
                    continue;
                }
                System.out.println("ERROR: " + e.getMessage());
                continue;
            }
            break;
        }
    }

    private static void showHelp() {
        System.out.println("Commands");
        System.out.println("--------");
        System.out.println("echo            -   toggles output echo on/off");
        System.out.println("template        -   use the template parser shell");
        System.out.println("stacktrace      -   toggles stacktraces on/off");
        System.out.println("benchmark       -   toggles benchmark mode on/off");
        System.out.println("exectime        -   toggles execution time display on/off");
        System.out.println("clear           -   clears all variables");
        System.out.println("quit            -   exits the shell");
        System.out.println("\n");
    }
}

