/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.Accessor;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.ast.Assignment;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class DeepAssignmentNode
extends ASTNode
implements Assignment {
    private String property;
    private Accessor baseAccessor;
    private Accessor statement;

    public DeepAssignmentNode(char[] expr, int fields) {
        super(expr, fields);
        String name;
        int mark = PropertyTools.find(expr, '=');
        if (mark != -1) {
            name = new String(expr, 0, mark).trim();
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(expr, mark + 1));
        } else {
            name = new String(expr);
        }
        mark = name.indexOf(46);
        this.baseAccessor = (Accessor)((Object)ParseTools.subCompileExpression(name.substring(0, mark)));
        this.property = name.substring(mark + 1);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object val = this.statement.getValue(ctx, thisValue, factory);
        MVEL.setProperty(this.baseAccessor.getValue(ctx, thisValue, factory), this.property, val);
        return val;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public String getAssignmentVar() {
        return this.property;
    }
}

