/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.lang.reflect.Method;
import org.mvel.ASTNode;
import org.mvel.Accessor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ArrayTools;
import org.mvel.util.ParseTools;

public class StaticMethodNode
extends ASTNode {
    private Accessor accessor;
    private String method;
    private Class declaringClass;

    public StaticMethodNode(char[] expr, int fields) {
        super(expr, fields);
        this.method = new String(ParseTools.subset(expr, ArrayTools.findFirst('(', expr)));
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return this.valRet(this.accessor.getValue(this.declaringClass, thisValue, factory));
        }
        catch (NullPointerException e) {
            if (this.accessor == null) {
                Method m = (Method)factory.getVariableResolver(this.method).getValue();
                this.declaringClass = m.getDeclaringClass();
                this.accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeAccessor(this.name, this.declaringClass, thisValue, factory, false);
                return this.valRet(this.accessor.getValue(this.declaringClass, thisValue, factory));
            }
            throw e;
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return super.getReducedValue(ctx, thisValue, factory);
    }
}

