/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.debug;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ASTIterator;
import org.mvel.ASTNode;
import org.mvel.CompiledExpression;
import org.mvel.ExecutableAccessor;
import org.mvel.ExecutableLiteral;
import org.mvel.ast.NestedStatement;
import org.mvel.integration.VariableResolver;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTools {
    public static String decompile(Serializable expr) {
        if (expr instanceof CompiledExpression) {
            return DebugTools.decompile((CompiledExpression)expr);
        }
        if (expr instanceof ExecutableAccessor) {
            return "CANNOT DECOMPILE OPTIMIZED STATEMENT (Run with -Dmvel.optimizer=false)";
        }
        if (expr instanceof ExecutableLiteral) {
            return new StringBuffer("LITERAL: ").append(((ExecutableLiteral)expr).getValue(null, null)).toString();
        }
        return new StringBuffer("NOT A KNOWN PAYLOAD: ").append(expr.getClass().getName()).toString();
    }

    public static String decompile(CompiledExpression cExp) {
        return DebugTools.decompile(cExp, false);
    }

    private static String decompile(CompiledExpression cExp, boolean nest) {
        ASTIterator iter = cExp.getTokens();
        int node = 0;
        StringBuffer sbuf = new StringBuffer();
        if (!nest) {
            sbuf.append("Expression Decompile\n-------------\n");
        }
        while (iter.hasMoreNodes()) {
            ASTNode tk = iter.nextNode();
            sbuf.append("(").append(node++).append(") ");
            if (tk instanceof NestedStatement && ((NestedStatement)((Object)tk)).getNestedStatement() instanceof CompiledExpression) {
                sbuf.append(new StringBuffer("ASTNODE [").append(ParseTools.getSimpleClassName(tk.getClass())).append("]: { ").append(tk.getName()).append(" }\n").toString());
                sbuf.append(DebugTools.decompile((CompiledExpression)((NestedStatement)((Object)tk)).getNestedStatement(), true));
            } else if (tk.isDebuggingSymbol()) {
                sbuf.append(new StringBuffer("DEBUG_SYMBOL ").append(tk.toString()).toString());
            } else if (tk.isLiteral()) {
                sbuf.append("PUSH LITERAL '").append(tk.getLiteralValue()).append("'");
            } else if (tk.isOperator()) {
                sbuf.append("OPERATOR [").append(DebugTools.getOperatorName(tk.getOperator())).append("]: ").append(tk.getName());
                if (tk.isOperator(new Integer(36))) {
                    sbuf.append("\n");
                }
            } else if (tk.isIdentifier()) {
                sbuf.append("PUSH VAR :: ").append(tk.getName());
            } else {
                sbuf.append(new StringBuffer("ASTNODE [").append(ParseTools.getSimpleClassName(tk.getClass())).append("]: { ").append(tk.getName()).append(" }").toString());
            }
            sbuf.append("\n");
        }
        sbuf.append("==END==");
        return sbuf.toString();
    }

    public static String getOperatorName(int operator) {
        switch (operator) {
            case 0: {
                return "ADD";
            }
            case 1: {
                return "SUBTRACT";
            }
            case 30: {
                return "ASSIGN";
            }
            case 52: {
                return "ASSIGN_ADD";
            }
            case 54: {
                return "ASSIGN_STR_APPEND";
            }
            case 53: {
                return "ASSIGN_SUB";
            }
            case 21: {
                return "BIT_AND";
            }
            case 22: {
                return "BIT_OR";
            }
            case 25: {
                return "BIT_SHIFT_LEFT";
            }
            case 24: {
                return "BIT_SHIFT_RIGHT";
            }
            case 27: {
                return "BIT_UNSIGNED_SHIFT_LEFT";
            }
            case 26: {
                return "BIT_UNSIGNED_SHIFT_RIGHT";
            }
            case 23: {
                return "BIT_XOR";
            }
            case 17: {
                return "CONTAINS";
            }
            case 35: {
                return "CONVERTABLE_TO";
            }
            case 51: {
                return "DECREMENT";
            }
            case 32: {
                return "DECREMENT_ASSIGN";
            }
            case 3: {
                return "DIVIDE";
            }
            case 43: {
                return "DO";
            }
            case 39: {
                return "ELSE";
            }
            case 36: {
                return "END_OF_STATEMENT";
            }
            case 10: {
                return "EQUAL";
            }
            case 41: {
                return "FOR";
            }
            case 37: {
                return "FOREACH";
            }
            case 100: {
                return "FUNCTION";
            }
            case 8: {
                return "GREATER_THAN_OR_EQUAL";
            }
            case 6: {
                return "GREATHER_THAN";
            }
            case 38: {
                return "IF";
            }
            case 50: {
                return "INCREMENT";
            }
            case 31: {
                return "INCREMENT_ASSIGN";
            }
            case 16: {
                return "INSTANCEOF";
            }
            case 7: {
                return "LESS_THAN_OR_EQUAL";
            }
            case 5: {
                return "LESS_THAN";
            }
            case 4: {
                return "MODULUS";
            }
            case 2: {
                return "MULTIPLY";
            }
            case 11: {
                return "NOT_EQUAL";
            }
            case 33: {
                return "NEW_OBJECT";
            }
            case 13: {
                return "OR";
            }
            case 9: {
                return "POWER_OF";
            }
            case 34: {
                return "PROJECT";
            }
            case 15: {
                return "REGEX";
            }
            case 99: {
                return "RETURN";
            }
            case 20: {
                return "SIMILARITY";
            }
            case 19: {
                return "SOUNDEX";
            }
            case 18: {
                return "STR_APPEND";
            }
            case 42: {
                return "SWITCH";
            }
            case 28: {
                return "TERNARY_IF";
            }
            case 29: {
                return "TERNARY_ELSE";
            }
            case 40: {
                return "WHILE";
            }
            case 14: {
                return "CHAINED_OR";
            }
        }
        return "UNKNOWN_OPERATOR";
    }

    public static Class determineType(String name, CompiledExpression compiledExpression) {
        ASTIterator iter = compiledExpression.getTokenIterator();
        while (iter.hasMoreNodes()) {
            ASTNode node = iter.nextNode();
            if (!name.equals(node.getName()) || !node.isAssignment()) continue;
            return node.getEgressType();
        }
        return null;
    }

    public static Map<String, VariableResolver> getAllVariableResolvers(VariableResolverFactory rootFactory) {
        HashMap<String, VariableResolver> allVariableResolvers = new HashMap<String, VariableResolver>();
        VariableResolverFactory vrf = rootFactory;
        do {
            for (String var : vrf.getKnownVariables()) {
                allVariableResolvers.put(var, vrf.getVariableResolver(var));
            }
        } while ((vrf = vrf.getNextFactory()) != null);
        return allVariableResolvers;
    }
}

