/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.mvel.CompileException;
import org.mvel.ConversionException;
import org.mvel.math.MathProcessor;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class IEEEFloatingPointMath
implements MathProcessor {
    public static final MathContext MATH_CONTEXT = MathContext.DECIMAL128;

    public Object doOperation(Object val1, int operation, Object val2) {
        int type2;
        int type1 = val1 == null ? -1 : ParseTools.resolveType(val1.getClass());
        int n = type2 = val2 == null ? -1 : ParseTools.resolveType(val2.getClass());
        if (type1 == 110) {
            if (type2 == 110) {
                return IEEEFloatingPointMath.doBigDecimalArithmetic((BigDecimal)val1, operation, (BigDecimal)val2);
            }
            if (type2 > 99) {
                return IEEEFloatingPointMath.doBigDecimalArithmetic((BigDecimal)val1, operation, IEEEFloatingPointMath.getBigDecimalFromType(val2, type2));
            }
            return IEEEFloatingPointMath._doOperations(type1, val1, operation, type2, val2);
        }
        if (type2 == 110 && (type1 > 99 || type1 == 1 && PropertyTools.isNumber(val1))) {
            return IEEEFloatingPointMath.doBigDecimalArithmetic(IEEEFloatingPointMath.getBigDecimalFromType(val1, type1), operation, (BigDecimal)val2);
        }
        return IEEEFloatingPointMath._doOperations(type1, val1, operation, type2, val2);
    }

    private static Object doBigDecimalArithmetic(BigDecimal val1, int operation, BigDecimal val2) {
        switch (operation) {
            case 0: {
                return val1.add(val2);
            }
            case 3: {
                return val1.divide(val2, MATH_CONTEXT);
            }
            case 1: {
                return val1.subtract(val2);
            }
            case 2: {
                return val1.multiply(val2);
            }
            case 9: {
                return new Double(Math.pow(val1.doubleValue(), val2.doubleValue()));
            }
            case 4: {
                return val1.remainder(val2);
            }
            case 6: {
                if (val1.compareTo(val2) == 1) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 8: {
                if (val1.compareTo(val2) >= 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 5: {
                if (val1.compareTo(val2) == -1) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 7: {
                if (val1.compareTo(val2) <= 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 10: {
                if (val1.compareTo(val2) == 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 11: {
                if (val1.compareTo(val2) != 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
        }
        return null;
    }

    private static Object _doOperations(int type1, Object val1, int operation, int type2, Object val2) {
        if (operation < 10 || operation == 10 || operation == 11) {
            if (type1 > 99 && type1 == type2) {
                return IEEEFloatingPointMath.doOperationsSameType(type1, val1, operation, val2);
            }
            if (type1 > 99 && type2 > 99 || PropertyTools.isNumber(val1) && PropertyTools.isNumber(val2)) {
                return IEEEFloatingPointMath.doBigDecimalArithmetic(IEEEFloatingPointMath.getBigDecimalFromType(val1, type1), operation, IEEEFloatingPointMath.getBigDecimalFromType(val2, type2));
            }
        }
        return IEEEFloatingPointMath.doOperationNonNumeric(val1, operation, val2);
    }

    private static Object doOperationNonNumeric(Object val1, int operation, Object val2) {
        switch (operation) {
            case 0: {
                return String.valueOf(String.valueOf(val1)) + String.valueOf(val2);
            }
            case 10: {
                return IEEEFloatingPointMath.safeEquals(val2, val1);
            }
            case 11: {
                return IEEEFloatingPointMath.safeNotEquals(val2, val1);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (!(val1 instanceof Comparable)) break;
                if (((Comparable)val1).compareTo(val2) == 1) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 8: {
                if (!(val1 instanceof Comparable)) break;
                if (((Comparable)val1).compareTo(val2) >= 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 5: {
                if (!(val1 instanceof Comparable)) break;
                if (((Comparable)val1).compareTo(val2) == -1) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 7: {
                if (!(val1 instanceof Comparable)) break;
                if (((Comparable)val1).compareTo(val2) <= 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
        }
        throw new CompileException("could not perform numeric operation on non-numeric types: left-type=" + (val1 != null ? val1.getClass().getName() : "null") + "; right-type=" + (val2 != null ? val2.getClass().getName() : "null"));
    }

    private static Boolean safeEquals(Object val1, Object val2) {
        if (val1 != null) {
            return new Boolean(val1.equals(val2));
        }
        if (val2 != null) {
            return new Boolean(val2.equals(val1));
        }
        if (val1 == val2) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    private static Boolean safeNotEquals(Object val1, Object val2) {
        if (val1 != null) {
            return new Boolean(!val1.equals(val2));
        }
        if (val2 != null && !val2.equals(val1)) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    private static Object doOperationsSameType(int type1, Object val1, int operation, Object val2) {
        switch (type1) {
            case 101: 
            case 106: {
                switch (operation) {
                    case 0: {
                        return new Integer((Integer)val1 + (Integer)val2);
                    }
                    case 1: {
                        return new Integer((Integer)val1 - (Integer)val2);
                    }
                    case 3: {
                        return new BigDecimal((Integer)val1).divide(new BigDecimal((Integer)val2), MATH_CONTEXT);
                    }
                    case 2: {
                        return new Integer((Integer)val1 * (Integer)val2);
                    }
                    case 9: {
                        double d = Math.pow(((Integer)val1).intValue(), ((Integer)val2).intValue());
                        if (d > 2.147483647E9) {
                            return new Double(d);
                        }
                        return new Integer((int)d);
                    }
                    case 4: {
                        return new Integer((Integer)val1 % (Integer)val2);
                    }
                    case 6: {
                        if ((Integer)val1 > (Integer)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 8: {
                        if ((Integer)val1 >= (Integer)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 5: {
                        if ((Integer)val1 < (Integer)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 7: {
                        if ((Integer)val1 <= (Integer)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 10: {
                        if (((Integer)val1).intValue() == ((Integer)val2).intValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 11: {
                        if (((Integer)val1).intValue() != ((Integer)val2).intValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                }
            }
            case 100: 
            case 105: {
                switch (operation) {
                    case 0: {
                        return new Integer((Short)val1 + (Short)val2);
                    }
                    case 1: {
                        return new Integer((Short)val1 - (Short)val2);
                    }
                    case 3: {
                        return new BigDecimal(((Short)val1).shortValue()).divide(new BigDecimal(((Short)val2).shortValue()), MATH_CONTEXT);
                    }
                    case 2: {
                        return new Integer((Short)val1 * (Short)val2);
                    }
                    case 9: {
                        double d = Math.pow(((Short)val1).shortValue(), ((Short)val2).shortValue());
                        if (d > 32767.0) {
                            return new Double(d);
                        }
                        return new Short((short)d);
                    }
                    case 4: {
                        return new Integer((Short)val1 % (Short)val2);
                    }
                    case 6: {
                        if ((Short)val1 > (Short)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 8: {
                        if ((Short)val1 >= (Short)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 5: {
                        if ((Short)val1 < (Short)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 7: {
                        if ((Short)val1 <= (Short)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 10: {
                        if (((Short)val1).shortValue() == ((Short)val2).shortValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 11: {
                        if (((Short)val1).shortValue() != ((Short)val2).shortValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                }
            }
            case 102: 
            case 107: {
                switch (operation) {
                    case 0: {
                        return new Long((Long)val1 + (Long)val2);
                    }
                    case 1: {
                        return new Long((Long)val1 - (Long)val2);
                    }
                    case 3: {
                        return new BigDecimal((Long)val1).divide(new BigDecimal((Long)val2), MATH_CONTEXT);
                    }
                    case 2: {
                        return new Long((Long)val1 * (Long)val2);
                    }
                    case 9: {
                        double d = Math.pow(((Long)val1).longValue(), ((Long)val2).longValue());
                        if (d > 9.223372036854776E18) {
                            return new Double(d);
                        }
                        return new Long((long)d);
                    }
                    case 4: {
                        return new Long((Long)val1 % (Long)val2);
                    }
                    case 6: {
                        if ((Long)val1 > (Long)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 8: {
                        if ((Long)val1 >= (Long)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 5: {
                        if ((Long)val1 < (Long)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 7: {
                        if ((Long)val1 <= (Long)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 10: {
                        if (((Long)val1).longValue() == ((Long)val2).longValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 11: {
                        if (((Long)val1).longValue() != ((Long)val2).longValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                }
            }
            case 103: 
            case 108: {
                switch (operation) {
                    case 0: {
                        return new Double((Double)val1 + (Double)val2);
                    }
                    case 1: {
                        return new Double((Double)val1 - (Double)val2);
                    }
                    case 3: {
                        return new BigDecimal((Double)val1).divide(new BigDecimal((Double)val2), MATH_CONTEXT);
                    }
                    case 2: {
                        return new Double((Double)val1 * (Double)val2);
                    }
                    case 9: {
                        return new Double(Math.pow((Double)val1, (Double)val2));
                    }
                    case 4: {
                        return new Double((Double)val1 % (Double)val2);
                    }
                    case 6: {
                        if ((Double)val1 > (Double)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 8: {
                        if ((Double)val1 >= (Double)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 5: {
                        if ((Double)val1 < (Double)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 7: {
                        if ((Double)val1 <= (Double)val2) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 10: {
                        if (((Double)val1).doubleValue() == ((Double)val2).doubleValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 11: {
                        if (((Double)val1).doubleValue() != ((Double)val2).doubleValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                }
            }
            case 104: 
            case 109: {
                switch (operation) {
                    case 0: {
                        return new Float(((Float)val1).floatValue() + ((Float)val2).floatValue());
                    }
                    case 1: {
                        return new Float(((Float)val1).floatValue() - ((Float)val2).floatValue());
                    }
                    case 3: {
                        return new BigDecimal(((Float)val1).floatValue()).divide(new BigDecimal(((Float)val2).floatValue()), MATH_CONTEXT);
                    }
                    case 2: {
                        return new Float(((Float)val1).floatValue() * ((Float)val2).floatValue());
                    }
                    case 9: {
                        return new BigDecimal(((Float)val1).floatValue()).pow(new BigDecimal(((Float)val2).floatValue()).intValue());
                    }
                    case 4: {
                        return new Float(((Float)val1).floatValue() % ((Float)val2).floatValue());
                    }
                    case 6: {
                        if (((Float)val1).floatValue() > ((Float)val2).floatValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 8: {
                        if (((Float)val1).floatValue() >= ((Float)val2).floatValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 5: {
                        if (((Float)val1).floatValue() < ((Float)val2).floatValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 7: {
                        if (((Float)val1).floatValue() <= ((Float)val2).floatValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 10: {
                        if (((Float)val1).floatValue() == ((Float)val2).floatValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 11: {
                        if (((Float)val1).floatValue() != ((Float)val2).floatValue()) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                }
            }
            case 111: {
                switch (operation) {
                    case 0: {
                        return ((BigInteger)val1).add((BigInteger)val2);
                    }
                    case 1: {
                        return ((BigInteger)val1).subtract((BigInteger)val2);
                    }
                    case 3: {
                        return ((BigInteger)val1).divide((BigInteger)val2);
                    }
                    case 2: {
                        return ((BigInteger)val1).multiply((BigInteger)val2);
                    }
                    case 9: {
                        return ((BigInteger)val1).pow(((BigInteger)val2).intValue());
                    }
                    case 4: {
                        return ((BigInteger)val1).remainder((BigInteger)val2);
                    }
                    case 6: {
                        if (((BigInteger)val1).compareTo((BigInteger)val2) == 1) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 8: {
                        if (((BigInteger)val1).compareTo((BigInteger)val2) >= 0) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 5: {
                        if (((BigInteger)val1).compareTo((BigInteger)val2) == -1) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 7: {
                        if (((BigInteger)val1).compareTo((BigInteger)val2) <= 0) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 10: {
                        if (((BigInteger)val1).compareTo((BigInteger)val2) == 0) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                    case 11: {
                        if (((BigInteger)val1).compareTo((BigInteger)val2) != 0) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                }
            }
        }
        switch (operation) {
            case 10: {
                return IEEEFloatingPointMath.safeEquals(val2, val1);
            }
            case 11: {
                return IEEEFloatingPointMath.safeNotEquals(val2, val1);
            }
            case 0: {
                return String.valueOf(String.valueOf(val1)) + String.valueOf(val2);
            }
        }
        return null;
    }

    public static BigDecimal getBigDecimalFromType(Object in, int type) {
        if (in == null) {
            return new BigDecimal(0);
        }
        switch (type) {
            case 110: {
                return (BigDecimal)in;
            }
            case 111: {
                return new BigDecimal((BigInteger)in);
            }
            case 106: {
                return new BigDecimal((Integer)in);
            }
            case 107: {
                return new BigDecimal((Long)in);
            }
            case 1: {
                return new BigDecimal((String)in);
            }
            case 109: {
                return new BigDecimal(((Float)in).floatValue());
            }
            case 108: {
                return new BigDecimal((Double)in);
            }
            case 105: {
                return new BigDecimal(((Short)in).shortValue());
            }
            case 16: {
                return new BigDecimal(((Character)in).charValue());
            }
        }
        throw new ConversionException("cannot convert <" + in + "> to a numeric type");
    }
}

