/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import java.util.ArrayList;
import java.util.HashMap;

public class CollectionParser {
    private char[] property;
    private int cursor;
    private int length;
    private int start;
    private int end;
    private int type;
    public static final int LIST = 0;
    public static final int ARRAY = 1;
    public static final int MAP = 2;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public CollectionParser() {
    }

    public CollectionParser(int type) {
        this.type = type;
    }

    public Object parseCollection(char[] property) {
        this.property = property;
        this.cursor = 0;
        this.length = property.length;
        if (this.length > 0) {
            while (Character.isWhitespace(property[this.length - 1])) {
                --this.length;
            }
        }
        return this.parseCollection();
    }

    private Object parseCollection() {
        if (this.length == 0) {
            if (this.type == 0) {
                return new ArrayList();
            }
            return EMPTY_ARRAY;
        }
        HashMap<String, Object> map = null;
        ArrayList<Object> list = null;
        if (this.type != -1) {
            switch (this.type) {
                case 0: 
                case 1: {
                    list = new ArrayList<Object>();
                    break;
                }
                case 2: {
                    map = new HashMap<String, Object>();
                }
            }
        }
        Object curr = null;
        int newType = -1;
        while (this.cursor < this.length) {
            switch (this.property[this.cursor]) {
                case '{': {
                    if (newType == -1) {
                        newType = 1;
                    }
                }
                case '[': {
                    if (newType == -1) {
                        newType = 0;
                    }
                    this.start = this.cursor;
                    int end = this.balancedCapture(this.property[this.cursor]);
                    Object o = new CollectionParser(newType).parseCollection(CollectionParser.subset(this.property, this.start + 1, end));
                    if (this.type == 2) {
                        map.put((String)curr, o);
                    } else {
                        curr = o;
                        list.add(curr);
                    }
                    this.start = ++this.cursor;
                    if (this.cursor >= this.length - 1 || this.property[this.start] != ',') break;
                    this.start = ++this.cursor;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.start = this.cursor;
                    int end = this.balancedCapture(this.property[this.start]);
                    if (end != -1) break;
                    throw new RuntimeException("unterminated string literal");
                }
                case ',': {
                    if (this.type != 2) {
                        list.add(new String(CollectionParser.subset(this.property, this.start, this.cursor)));
                    } else {
                        map.put((String)curr, new String(CollectionParser.subset(this.property, this.start, this.cursor)).trim());
                    }
                    this.start = this.cursor + 1;
                    break;
                }
                case ':': {
                    if (this.type != 2) {
                        map = new HashMap();
                        this.type = 2;
                    }
                    curr = new String(CollectionParser.subset(this.property, this.start, this.cursor)).trim();
                    this.start = this.cursor + 1;
                }
            }
            ++this.cursor;
        }
        if (this.start < this.length) {
            if (this.cursor < this.length - 1) {
                ++this.cursor;
            }
            if (this.type == 2) {
                map.put((String)curr, new String(CollectionParser.subset(this.property, this.start, this.cursor)).trim());
            } else {
                if (this.cursor < this.length) {
                    ++this.cursor;
                }
                list.add(new String(CollectionParser.subset(this.property, this.start, this.cursor)).trim());
            }
        }
        switch (this.type) {
            case 2: {
                return map;
            }
            case 1: {
                return list.toArray();
            }
        }
        return list;
    }

    private static char[] subset(char[] property, int start, int end) {
        while (start < end - 1 && Character.isWhitespace(property[start])) {
            ++start;
        }
        char[] newA = new char[end - start];
        System.arraycopy(property, start, newA, 0, end - start);
        return newA;
    }

    private int balancedCapture(char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
            }
        }
        if (type == term) {
            ++this.cursor;
            while (this.cursor < this.length) {
                if (this.property[this.cursor] == type) {
                    this.end = this.cursor;
                    return this.end;
                }
                ++this.cursor;
            }
        } else {
            ++this.cursor;
            while (this.cursor < this.length) {
                if (this.property[this.cursor] == type) {
                    ++depth;
                } else if (this.property[this.cursor] == term && --depth == 0) {
                    this.end = this.cursor;
                    return this.end;
                }
                ++this.cursor;
            }
        }
        return -1;
    }

    public int getEnd() {
        return this.end;
    }
}

