/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.Accessor;
import org.mvel.CompileException;
import org.mvel.ParserContext;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ArrayTools;

public class NewObjectNode
extends ASTNode {
    private transient Accessor newObjectOptimizer;
    private String className;

    public NewObjectNode(char[] expr, int fields) {
        super(expr, fields);
        this.updateClassName();
        if ((fields & 0x10) != 0) {
            ParserContext pCtx = AbstractParser.getCurrentThreadParserContext();
            if (pCtx != null && pCtx.hasImport(this.className)) {
                this.egressType = pCtx.getImport(this.className);
            } else {
                try {
                    this.egressType = Thread.currentThread().getContextClassLoader().loadClass(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (this.egressType != null) {
                this.rewriteClassReferenceToFQCN();
            }
        }
    }

    private void rewriteClassReferenceToFQCN() {
        String FQCN = this.egressType.getName();
        if (this.className.indexOf(46) == -1) {
            int idx = FQCN.lastIndexOf(36);
            this.name = idx != -1 && this.className.lastIndexOf(36) == -1 ? (String.valueOf(FQCN.substring(0, idx + 1)) + new String(this.name)).toCharArray() : (String.valueOf(FQCN.substring(0, FQCN.lastIndexOf(46) + 1)) + new String(this.name)).toCharArray();
            this.updateClassName();
        }
    }

    private void updateClassName() {
        int endRange = ArrayTools.findFirst('(', this.name);
        this.className = endRange == -1 ? new String(this.name) : new String(this.name, 0, ArrayTools.findFirst('(', this.name));
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.newObjectOptimizer == null) {
            if (this.egressType == null && factory != null && factory.isResolveable(this.className)) {
                try {
                    this.egressType = (Class)factory.getVariableResolver(this.className).getValue();
                    this.rewriteClassReferenceToFQCN();
                }
                catch (ClassCastException e) {
                    throw new CompileException("cannot construct object: " + this.className + " is not a class reference", e);
                }
            }
            AccessorOptimizer optimizer = OptimizerFactory.getThreadAccessorOptimizer();
            this.newObjectOptimizer = optimizer.optimizeObjectCreation(this.name, ctx, thisValue, factory);
            if (optimizer.getResultOptPass() != null) {
                this.egressType = optimizer.getEgressType();
                return optimizer.getResultOptPass();
            }
        }
        return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public Accessor getNewObjectOptimizer() {
        return this.newObjectOptimizer;
    }
}

