/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class NoValueOfOnStringType
extends Recipe {
    private static final MethodMatcher VALUE_OF = new MethodMatcher("java.lang.String valueOf(..)");

    public String getDisplayName() {
        return "Unnecessary `String#valueOf(..)`";
    }

    public String getDescription() {
        return "Replace unnecessary `String#valueOf(..)` method invocations with the argument directly. This occurs when the argument to `String#valueOf(arg)` is a string literal, such as `String.valueOf(\"example\")`. Or, when the `String#valueOf(..)` invocation is used in a concatenation, such as `\"example\" + String.valueOf(\"example\")`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1153");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(4L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(new MethodMatcher("java.lang.String valueOf(..)")), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate t = JavaTemplate.builder((String)"#{any(java.lang.String)}").build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Expression argument;
                if (VALUE_OF.matches(method.getSelect())) {
                    return method;
                }
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (VALUE_OF.matches((MethodCall)mi) && mi.getArguments().size() == 1 && (TypeUtils.isString((JavaType)(argument = (Expression)mi.getArguments().get(0)).getType()) || this.removeValueOfFromBinaryExpression(argument))) {
                    return this.t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{argument});
                }
                return mi;
            }

            private boolean removeValueOfFromBinaryExpression(Expression argument) {
                if (TypeUtils.asPrimitive((JavaType)argument.getType()) != null) {
                    J parent;
                    J j = parent = this.getCursor().getParent() != null ? (J)this.getCursor().getParent().firstEnclosing(J.class) : null;
                    if (parent instanceof J.Binary) {
                        J.Binary b = (J.Binary)parent;
                        JavaType otherType = b.getRight() == this.getCursor().getValue() ? b.getLeft().getType() : b.getRight().getType();
                        return TypeUtils.isString((JavaType)otherType) && b.getOperator() == J.Binary.Type.Addition;
                    }
                }
                return false;
            }
        });
    }
}

