/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.staticanalysis.RenameToCamelCase;

public class RenameLocalVariablesToCamelCase
extends Recipe {
    public String getDisplayName() {
        return "Reformat local variable names to camelCase";
    }

    public String getDescription() {
        return "Reformat local variable and method parameter names to camelCase to comply with Java naming convention. The recipe will not rename variables declared in for loop controls or catches with a single character. The first character is set to lower case and existing capital letters are preserved. Special characters that are allowed in java field names `$` and `_` are removed (unless the name starts with one). If a special character is removed the next valid alphanumeric will be capitalized. Currently, does not support renaming members of classes. The recipe will not rename a variable if the result already exists in the class, conflicts with a java reserved keyword, or the result is blank.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S117");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RenameToCamelCase(){

            @Override
            protected boolean shouldRename(Set<String> hasNameSet, J.VariableDeclarations.NamedVariable variable, String toName) {
                if (toName.isEmpty() || !Character.isAlphabetic(toName.charAt(0))) {
                    return false;
                }
                return this.isAvailableIdentifier(toName, (J)variable, hasNameSet);
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (!this.isLocalVariable(mv)) {
                    return mv;
                }
                List variables = mv.getVariables();
                for (J.VariableDeclarations.NamedVariable v : variables) {
                    String name = v.getSimpleName();
                    if (!NameCaseConvention.LOWER_CAMEL.matches(name) && name.length() > 1) {
                        this.renameVariable(v, NameCaseConvention.LOWER_CAMEL.format(name));
                        continue;
                    }
                    this.hasNameKey(this.computeKey(name, (J)v));
                }
                return mv;
            }

            private boolean isLocalVariable(J.VariableDeclarations mv) {
                if (!this.isInMethodDeclarationBody() || this.isDeclaredInForLoopControl() || this.isDeclaredInCatch() || this.isMethodArgument()) {
                    return false;
                }
                for (J.VariableDeclarations.NamedVariable v : mv.getVariables()) {
                    if (!v.isField(this.getCursor())) continue;
                    return false;
                }
                return true;
            }

            private boolean isMethodArgument() {
                return this.getCursor().getParentTreeCursor().getValue() instanceof J.MethodDeclaration;
            }

            private boolean isInMethodDeclarationBody() {
                return this.getCursor().dropParentUntil(p -> p instanceof J.MethodDeclaration || p instanceof J.ClassDeclaration || p instanceof J.NewClass || p == "root").getValue() instanceof J.MethodDeclaration;
            }

            private boolean isDeclaredInForLoopControl() {
                return this.getCursor().getParentTreeCursor().getValue() instanceof J.ForLoop.Control;
            }

            private boolean isDeclaredInCatch() {
                Cursor parentScope = this.getCursorToParentScope(this.getCursor());
                return parentScope.getValue() instanceof J.Try.Catch || parentScope.getValue() instanceof J.MultiCatch;
            }

            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                this.hasNameKey(this.computeKey(identifier.getSimpleName(), (J)identifier));
                return identifier;
            }

            private Cursor getCursorToParentScope(Cursor cursor) {
                return cursor.dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.ForLoop.Control || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda || is instanceof JavaSourceFile);
            }

            private boolean isAvailableIdentifier(String identifier, J context, Set<String> hasNameSet) {
                if (hasNameSet.contains(identifier)) {
                    return false;
                }
                JavaType.Variable fieldType = this.getFieldType(context);
                if (fieldType != null && fieldType.getOwner() != null) {
                    if (hasNameSet.contains(fieldType.getOwner() + " " + identifier)) {
                        return false;
                    }
                    if (fieldType.getOwner() instanceof JavaType.Method) {
                        for (JavaType.FullyQualified declaringType = ((JavaType.Method)fieldType.getOwner()).getDeclaringType(); declaringType != null; declaringType = declaringType.getOwningClass()) {
                            if (!hasNameSet.contains(declaringType + " " + identifier)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        };
    }
}

