/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.csharp.CSharpFileChecker;

public class CatchClauseOnlyRethrows
extends Recipe {
    public String getDisplayName() {
        return "Catch clause should do more than just rethrow";
    }

    public String getDescription() {
        return "A `catch` clause that only rethrows the caught exception is unnecessary. Letting the exception bubble up as normal achieves the same result with less code.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2737");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = super.visitBlock(block, (Object)ctx);
                return b.withStatements(ListUtils.flatMap((List)b.getStatements(), statement -> {
                    J.Try aTry;
                    if (statement instanceof J.Try && (aTry = (J.Try)statement).getCatches().isEmpty() && aTry.getResources() == null && aTry.getFinally() == null) {
                        return ListUtils.map((List)aTry.getBody().getStatements(), tryStat -> (Statement)this.autoFormat((J)tryStat, ctx, this.getCursor()));
                    }
                    return statement;
                }));
            }

            public J.Try visitTry(J.Try tryable, ExecutionContext ctx) {
                J.Try t = super.visitTry(tryable, (Object)ctx);
                return t.withCatches(ListUtils.map((List)t.getCatches(), (i, aCatch) -> {
                    if (this.onlyRethrows((J.Try.Catch)aCatch)) {
                        for (int j = i + 1; j < tryable.getCatches().size(); ++j) {
                            J.Try.Catch next = (J.Try.Catch)tryable.getCatches().get(j);
                            if (!this.isAnyAssignableTo(this.getJavaTypes(next), this.getJavaTypes((J.Try.Catch)aCatch)) || this.onlyRethrows(next)) continue;
                            return aCatch;
                        }
                        return null;
                    }
                    return aCatch;
                }));
            }

            private List<JavaType> getJavaTypes(J.Try.Catch next) {
                if (next.getParameter().getType() instanceof JavaType.MultiCatch) {
                    JavaType.MultiCatch multiCatch = (JavaType.MultiCatch)next.getParameter().getType();
                    return multiCatch.getThrowableTypes();
                }
                return next.getParameter().getType() == null ? Collections.emptyList() : Collections.singletonList(next.getParameter().getType());
            }

            private boolean isAnyAssignableTo(List<JavaType> nextTypes, List<JavaType> aCatchTypes) {
                for (JavaType aCatchType : aCatchTypes) {
                    for (JavaType nextType : nextTypes) {
                        if (!TypeUtils.isAssignableTo((JavaType)nextType, (JavaType)aCatchType)) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean onlyRethrows(J.Try.Catch aCatch) {
                JavaType.FullyQualified catchType;
                if (aCatch.getBody().getStatements().size() != 1 || !(aCatch.getBody().getStatements().get(0) instanceof J.Throw)) {
                    return false;
                }
                Expression exception = ((J.Throw)aCatch.getBody().getStatements().get(0)).getException();
                if (CSharpFileChecker.isInstanceOfCs((Tree)this.getCursor().firstEnclosing(SourceFile.class)) && exception instanceof J.Empty) {
                    return true;
                }
                JavaType catchParameterType = aCatch.getParameter().getType();
                if (!(catchParameterType instanceof JavaType.MultiCatch || (catchType = TypeUtils.asFullyQualified((JavaType)catchParameterType)) != null && catchType.equals(exception.getType()))) {
                    return false;
                }
                if (exception instanceof J.Identifier) {
                    return ((J.Identifier)exception).getSimpleName().equals(((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)aCatch.getParameter().getTree()).getVariables().get(0)).getSimpleName());
                }
                return false;
            }
        };
    }
}

