/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class VariableReferences {
    private static boolean isIncrementKind(Cursor tree) {
        return tree.getValue() instanceof J.Unary && ((J.Unary)tree.getValue()).getOperator().isModifying();
    }

    private static @Nullable Cursor dropParentWhile(Predicate<Object> valuePredicate, Cursor cursor) {
        while (cursor != null && valuePredicate.test(cursor.getValue())) {
            cursor = cursor.getParent();
        }
        return cursor;
    }

    private static @Nullable Cursor dropParentUntil(Predicate<Object> valuePredicate, Cursor cursor) {
        while (cursor != null && !valuePredicate.test(cursor.getValue())) {
            cursor = cursor.getParent();
        }
        return cursor;
    }

    private static boolean isRhsValue(Cursor tree) {
        J.AssignmentOperation assignmentOperation;
        if (!(tree.getValue() instanceof J.Identifier)) {
            return false;
        }
        Cursor parent = VariableReferences.dropParentWhile(J.Parentheses.class::isInstance, tree.getParent());
        assert (parent != null);
        if (parent.getValue() instanceof J.Assignment) {
            if (VariableReferences.dropParentUntil(J.ControlParentheses.class::isInstance, parent) != null) {
                return true;
            }
            J.Assignment assignment = (J.Assignment)parent.getValue();
            return assignment.getVariable() != tree.getValue();
        }
        if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable) {
            J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)parent.getValue();
            return namedVariable.getName() != tree.getValue();
        }
        if (parent.getValue() instanceof J.AssignmentOperation && (assignmentOperation = (J.AssignmentOperation)parent.getValue()).getVariable() == tree.getValue()) {
            Tree grandParent = (Tree)parent.getParentTreeCursor().getValue();
            return grandParent instanceof Expression || grandParent instanceof J.Return;
        }
        return !VariableReferences.isIncrementKind(parent) || !(parent.getParentTreeCursor().getValue() instanceof J.Block);
    }

    public static List<J> findRhsReferences(J j, final J.Identifier target) {
        ArrayList<J> refs = new ArrayList<J>();
        new JavaIsoVisitor<List<J>>(){

            public J.Identifier visitIdentifier(J.Identifier identifier, List<J> ctx) {
                if (identifier.getSimpleName().equals(target.getSimpleName()) && VariableReferences.isRhsValue(this.getCursor())) {
                    ctx.add((J)identifier);
                }
                return super.visitIdentifier(identifier, ctx);
            }
        }.visit((Tree)j, refs);
        return refs;
    }

    public static List<Statement> findLhsReferences(J j, final J.Identifier target) {
        JavaIsoVisitor<List<Statement>> visitor = new JavaIsoVisitor<List<Statement>>(){

            public J.Assignment visitAssignment(J.Assignment assignment, List<Statement> ctx) {
                J.Identifier i;
                if (assignment.getVariable() instanceof J.Identifier && (i = (J.Identifier)assignment.getVariable()).getSimpleName().equals(target.getSimpleName())) {
                    ctx.add((Statement)assignment);
                }
                return super.visitAssignment(assignment, ctx);
            }

            public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, List<Statement> ctx) {
                J.Identifier i;
                if (assignOp.getVariable() instanceof J.Identifier && (i = (J.Identifier)assignOp.getVariable()).getSimpleName().equals(target.getSimpleName())) {
                    ctx.add((Statement)assignOp);
                }
                return super.visitAssignmentOperation(assignOp, ctx);
            }

            public J.Unary visitUnary(J.Unary unary, List<Statement> ctx) {
                J.Identifier i;
                if (unary.getExpression() instanceof J.Identifier && (i = (J.Identifier)unary.getExpression()).getSimpleName().equals(target.getSimpleName())) {
                    ctx.add((Statement)unary);
                }
                return super.visitUnary(unary, ctx);
            }
        };
        ArrayList<Statement> refs = new ArrayList<Statement>();
        visitor.visit((Tree)j, refs);
        return refs;
    }
}

