/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class AssertTrueEqualsToAssertEquals
extends Recipe {
    private static final MethodMatcher ASSERT_TRUE = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");

    public String getDisplayName() {
        return "Replace JUnit `assertTrue(a.equals(b))` to `assertEquals(a,b)`";
    }

    public String getDescription() {
        return "Using `assertEquals(a,b)` is simpler and more clear.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(ASSERT_TRUE);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            Supplier<JavaParser> javaParser = null;

            private Supplier<JavaParser> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9.2"}).build();
                }
                return this.javaParser;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_TRUE.matches(mi) && this.isEquals((Expression)mi.getArguments().get(0))) {
                    Object[] args;
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertEquals");
                    } else {
                        sb.append("Assertions.");
                    }
                    J.MethodInvocation s = (J.MethodInvocation)mi.getArguments().get(0);
                    sb.append("assertEquals(#{any(java.lang.Object)},#{any(java.lang.Object)}");
                    if (mi.getArguments().size() == 2) {
                        args = new Object[]{s.getSelect(), s.getArguments().get(0), mi.getArguments().get(1)};
                        sb.append(", #{any()}");
                    } else {
                        args = new Object[]{s.getSelect(), s.getArguments().get(0)};
                    }
                    sb.append(")");
                    JavaTemplate t = mi.getSelect() == null ? JavaTemplate.builder(() -> (this).getCursor(), (String)sb.toString()).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertEquals"}).javaParser(this.javaParser(ctx)).build() : JavaTemplate.builder(() -> (this).getCursor(), (String)sb.toString()).imports(new String[]{"org.junit.jupiter.api.Assertions.assertEquals"}).javaParser(this.javaParser(ctx)).build();
                    return mi.withTemplate((SourceTemplate)t, mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean isEquals(Expression expr) {
                if (!(expr instanceof J.MethodInvocation)) {
                    return false;
                }
                J.MethodInvocation methodInvocation = (J.MethodInvocation)expr;
                return "equals".equals(methodInvocation.getName().getSimpleName()) && methodInvocation.getArguments().size() == 1;
            }
        };
    }
}

