/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class LifecycleNonPrivate
extends Recipe {
    private static final List<String> ANNOTATION_TYPES = Arrays.asList("org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.BeforeEach");

    public String getDisplayName() {
        return "Make lifecycle methods non private";
    }

    public String getDescription() {
        return "Make JUnit 5's `@AfterAll`, `@AfterEach`, `@BeforeAll` and `@BeforeEach` non private.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                ANNOTATION_TYPES.forEach(ann -> this.doAfterVisit((TreeVisitor)new UsesType(ann, Boolean.valueOf(false))));
                return cu;
            }
        };
    }

    protected LifecycleNonPrivateVisitor getVisitor() {
        return new LifecycleNonPrivateVisitor();
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    private static class LifecycleNonPrivateVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        final List<AnnotationMatcher> lifeCycleAnnotationMatchers = LifecycleNonPrivate.access$000().stream().map(annoFqn -> "@" + annoFqn).map(AnnotationMatcher::new).collect(Collectors.toList());

        private LifecycleNonPrivateVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
            if (J.Modifier.hasModifier((Collection)md.getModifiers(), (J.Modifier.Type)J.Modifier.Type.Private) && md.getLeadingAnnotations().stream().anyMatch(ann -> this.lifeCycleAnnotationMatchers.stream().anyMatch(matcher -> matcher.matches(ann)))) {
                return (J.MethodDeclaration)this.maybeAutoFormat((J)md, (J)md.withModifiers(ListUtils.map((List)md.getModifiers(), modifier -> modifier.getType() == J.Modifier.Type.Private ? null : modifier)), ctx, this.getCursor().getParentOrThrow());
            }
            return md;
        }
    }
}

