/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class UpdateBeforeAfterAnnotations
extends Recipe {
    public String getDisplayName() {
        return "Migrate JUnit 4 lifecycle annotations to JUnit Jupiter";
    }

    public String getDescription() {
        return "Replace JUnit 4's `@Before`, `@BeforeClass`, `@After`, and `@AfterClass` annotations with their JUnit Jupiter equivalents.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.BeforeClass", Boolean.valueOf(false)));
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.Before", Boolean.valueOf(false)));
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.After", Boolean.valueOf(false)));
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.AfterClass", Boolean.valueOf(false)));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UpdateBeforeAfterAnnotationsVisitor();
    }

    public static class UpdateBeforeAfterAnnotationsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.doAfterVisit((Recipe)new ChangeType("org.junit.Before", "org.junit.jupiter.api.BeforeEach", Boolean.valueOf(true)));
            this.doAfterVisit((Recipe)new ChangeType("org.junit.After", "org.junit.jupiter.api.AfterEach", Boolean.valueOf(true)));
            this.doAfterVisit((Recipe)new ChangeType("org.junit.BeforeClass", "org.junit.jupiter.api.BeforeAll", Boolean.valueOf(true)));
            this.doAfterVisit((Recipe)new ChangeType("org.junit.AfterClass", "org.junit.jupiter.api.AfterAll", Boolean.valueOf(true)));
            return super.visitCompilationUnit(cu, (Object)ctx);
        }
    }
}

