/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.MessageContextLookup;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MessageContextLookupTest {
    private InOutOperationContext opContext;

    @BeforeMethod
    public void setUp() {
        this.opContext = new InOutOperationContext(new MessageContext(), new MessageContext());
    }

    @Test
    public void testInboundFromSame() {
        MockContext input = new MockContext();
        this.opContext.ensureInboundMessageContext().addSubcontext((BaseContext)input);
        MessageContextLookup lookup = new MessageContextLookup(MessageContextLookup.Direction.INBOUND);
        Assert.assertSame((Object)lookup.apply((BaseContext)input), (Object)this.opContext.getInboundMessageContext());
    }

    @Test
    public void testOutboundFromSame() {
        MockContext input = new MockContext();
        this.opContext.ensureOutboundMessageContext().addSubcontext((BaseContext)input);
        MessageContextLookup lookup = new MessageContextLookup(MessageContextLookup.Direction.OUTBOUND);
        Assert.assertSame((Object)lookup.apply((BaseContext)input), (Object)this.opContext.getOutboundMessageContext());
    }

    @Test
    public void testInboundFromCrosswalk() {
        MockContext input = new MockContext();
        this.opContext.ensureOutboundMessageContext().addSubcontext((BaseContext)input);
        MessageContextLookup lookup = new MessageContextLookup(MessageContextLookup.Direction.INBOUND);
        Assert.assertSame((Object)lookup.apply((BaseContext)input), (Object)this.opContext.getInboundMessageContext());
    }

    @Test
    public void testOutboundFromCrosswalk() {
        MockContext input = new MockContext();
        this.opContext.ensureInboundMessageContext().addSubcontext((BaseContext)input);
        MessageContextLookup lookup = new MessageContextLookup(MessageContextLookup.Direction.OUTBOUND);
        Assert.assertSame((Object)lookup.apply((BaseContext)input), (Object)this.opContext.getOutboundMessageContext());
    }

    @Test
    public void testNoParentOpContext() {
        MessageContextLookup lookup = new MessageContextLookup(MessageContextLookup.Direction.INBOUND);
        Assert.assertNull((Object)lookup.apply((BaseContext)new MessageContext()));
    }

    private static class MockContext
    extends BaseContext {
        private MockContext() {
        }
    }
}

