/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RecursiveTypedParentContextLookupTest {
    @Test
    public void testBasic() {
        MockContext1 mc1 = new MockContext1();
        MockContext2 mc2 = new MockContext2();
        MockContext3 mc3 = new MockContext3();
        MessageContext in = new MessageContext();
        InOutOperationContext opContext = new InOutOperationContext(null, null);
        opContext.setInboundMessageContext(in);
        opContext.ensureInboundMessageContext().addSubcontext((BaseContext)mc1);
        mc1.addSubcontext(mc2);
        mc2.addSubcontext(mc3);
        Assert.assertSame((Object)new RecursiveTypedParentContextLookup(MockContext2.class).apply((BaseContext)mc3), (Object)((Object)mc2));
        Assert.assertSame((Object)new RecursiveTypedParentContextLookup(MockContext1.class).apply((BaseContext)mc3), (Object)((Object)mc1));
        Assert.assertSame((Object)new RecursiveTypedParentContextLookup(MessageContext.class).apply((BaseContext)mc3), (Object)in);
        Assert.assertSame((Object)new RecursiveTypedParentContextLookup(InOutOperationContext.class).apply((BaseContext)mc3), (Object)opContext);
        Assert.assertNull((Object)new RecursiveTypedParentContextLookup(MockContextNotThere.class).apply((BaseContext)mc3));
        Assert.assertNull((Object)new RecursiveTypedParentContextLookup(InOutOperationContext.class).apply(null));
    }

    public static class MockContext1
    extends BaseContext {
        public String value;
    }

    public static class MockContext2
    extends BaseContext {
        public String value;
    }

    public static class MockContext3
    extends BaseContext {
        public String value;
    }

    public static class MockContextNotThere
    extends BaseContext {
        public String value;
    }
}

