/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler;

import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractMessageHandlerTest {
    @Test
    public void testSuccess() throws Exception {
        BaseMessageHandler handler = new BaseMessageHandler();
        handler.initialize();
        handler.invoke(new MessageContext());
        Assert.assertTrue((boolean)handler.didPre);
        Assert.assertTrue((boolean)handler.didExec);
        Assert.assertTrue((boolean)handler.didPost);
    }

    @Test
    public void testPreFailure() throws Exception {
        PreFailMessageHandler handler = new PreFailMessageHandler();
        handler.initialize();
        try {
            handler.invoke(new MessageContext());
        }
        catch (MessageHandlerException e) {
            Assert.assertFalse((boolean)handler.didPre);
            Assert.assertFalse((boolean)handler.didExec);
            Assert.assertFalse((boolean)handler.didPost);
        }
    }

    @Test
    public void testExecFailure() throws Exception {
        ExecFailMessageHandler handler = new ExecFailMessageHandler();
        handler.initialize();
        try {
            handler.invoke(new MessageContext());
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)(e.getSuppressed()[0] instanceof MessageHandlerException));
            Assert.assertTrue((boolean)handler.didPre);
            Assert.assertFalse((boolean)handler.didExec);
            Assert.assertFalse((boolean)handler.didPost);
        }
    }

    @Test
    public void testExecUnchecked() throws Exception {
        ExecUncheckedMessageHandler handler = new ExecUncheckedMessageHandler();
        handler.initialize();
        try {
            handler.invoke(new MessageContext());
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)(e.getSuppressed()[0] instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)handler.didPre);
            Assert.assertFalse((boolean)handler.didExec);
            Assert.assertTrue((boolean)handler.didPost);
        }
    }

    @Test
    public void testPostFailure() throws Exception {
        PostFailMessageHandler handler = new PostFailMessageHandler();
        handler.initialize();
        try {
            handler.invoke(new MessageContext());
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)handler.didPre);
            Assert.assertTrue((boolean)handler.didExec);
            Assert.assertFalse((boolean)handler.didPost);
        }
    }

    @Test
    public void testTrueActivationCondition() throws Exception {
        MockMutatingHandler handler = new MockMutatingHandler();
        handler.setActivationCondition(PredicateSupport.alwaysTrue());
        handler.initialize();
        MessageContext messageContext = new MessageContext();
        handler.invoke(messageContext);
        Assert.assertTrue((boolean)messageContext.containsSubcontext(MockContext.class));
        Assert.assertEquals((String)((MockContext)messageContext.ensureSubcontext(MockContext.class)).value, (String)"hello");
    }

    @Test
    public void testFalseActivationCondition() throws Exception {
        MockMutatingHandler handler = new MockMutatingHandler();
        handler.setActivationCondition(PredicateSupport.alwaysFalse());
        handler.initialize();
        MessageContext messageContext = new MessageContext();
        handler.invoke(messageContext);
        Assert.assertFalse((boolean)messageContext.containsSubcontext(MockContext.class));
    }

    private class BaseMessageHandler
    extends AbstractMessageHandler {
        private boolean didPre = false;
        private boolean didExec = false;
        private boolean didPost = false;

        private BaseMessageHandler() {
        }

        protected boolean doPreInvoke(@Nonnull MessageContext mc) throws MessageHandlerException {
            this.didPre = true;
            return true;
        }

        protected void doInvoke(@Nonnull MessageContext mc) throws MessageHandlerException {
            this.didExec = true;
        }

        protected void doPostInvoke(@Nonnull MessageContext mc) {
            this.didPost = true;
        }
    }

    private class PreFailMessageHandler
    extends BaseMessageHandler {
        private PreFailMessageHandler() {
        }

        @Override
        protected boolean doPreInvoke(@Nonnull MessageContext mc) throws MessageHandlerException {
            throw new MessageHandlerException();
        }
    }

    private class ExecFailMessageHandler
    extends BaseMessageHandler {
        private ExecFailMessageHandler() {
        }

        @Override
        protected void doInvoke(@Nonnull MessageContext mc) throws MessageHandlerException {
            throw new MessageHandlerException();
        }

        @Override
        protected void doPostInvoke(@Nonnull MessageContext mc) {
            throw new NullPointerException();
        }
    }

    private class ExecUncheckedMessageHandler
    extends BaseMessageHandler {
        private ExecUncheckedMessageHandler() {
        }

        @Override
        protected void doInvoke(@Nonnull MessageContext mc) throws MessageHandlerException {
            throw new IllegalArgumentException();
        }

        @Override
        protected void doPostInvoke(@Nonnull MessageContext mc) {
            super.doPostInvoke(mc);
            throw new NullPointerException();
        }
    }

    private class PostFailMessageHandler
    extends BaseMessageHandler {
        private PostFailMessageHandler() {
        }

        @Override
        protected void doPostInvoke(@Nonnull MessageContext mc) {
            throw new NullPointerException();
        }
    }

    private class MockMutatingHandler
    extends AbstractMessageHandler {
        private MockMutatingHandler() {
        }

        protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
            ((MockContext)messageContext.ensureSubcontext(MockContext.class)).value = "hello";
        }
    }

    public static class MockContext
    extends BaseContext {
        public String value;
    }
}

