/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action;

import javax.annotation.Nonnull;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractProfileActionTest {
    @Test
    public void testSuccess() throws Exception {
        BaseProfileAction action = new BaseProfileAction();
        action.initialize();
        action.execute(new ProfileRequestContext());
        Assert.assertTrue((boolean)action.didPre);
        Assert.assertTrue((boolean)action.didExec);
        Assert.assertTrue((boolean)action.didPost);
    }

    @Test
    public void testPreFailure() throws Exception {
        PreFailProfileAction action = new PreFailProfileAction();
        action.initialize();
        try {
            action.execute(new ProfileRequestContext());
        }
        catch (Exception e) {
            Assert.assertFalse((boolean)action.didPre);
            Assert.assertFalse((boolean)action.didExec);
            Assert.assertFalse((boolean)action.didPost);
        }
    }

    @Test
    public void testExecFailure() throws Exception {
        ExecFailProfileAction action = new ExecFailProfileAction();
        action.initialize();
        try {
            action.execute(new ProfileRequestContext());
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)(e.getSuppressed()[0] instanceof RuntimeException));
            Assert.assertTrue((boolean)action.didPre);
            Assert.assertFalse((boolean)action.didExec);
            Assert.assertFalse((boolean)action.didPost);
        }
    }

    @Test
    public void testExecUnchecked() throws Exception {
        ExecUncheckedProfileAction action = new ExecUncheckedProfileAction();
        action.initialize();
        try {
            action.execute(new ProfileRequestContext());
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)(e.getSuppressed()[0] instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)action.didPre);
            Assert.assertFalse((boolean)action.didExec);
            Assert.assertTrue((boolean)action.didPost);
        }
    }

    @Test
    public void testPostFailure() throws Exception {
        PostFailProfileAction action = new PostFailProfileAction();
        action.initialize();
        try {
            action.execute(new ProfileRequestContext());
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)action.didPre);
            Assert.assertTrue((boolean)action.didExec);
            Assert.assertFalse((boolean)action.didPost);
        }
    }

    private class PostFailProfileAction
    extends BaseProfileAction {
        private PostFailProfileAction() {
        }

        @Override
        protected void doPostExecute(@Nonnull ProfileRequestContext prc) {
            throw new NullPointerException();
        }
    }

    private class ExecUncheckedProfileAction
    extends BaseProfileAction {
        private ExecUncheckedProfileAction() {
        }

        @Override
        protected void doExecute(@Nonnull ProfileRequestContext prc) {
            throw new IllegalArgumentException();
        }

        @Override
        protected void doPostExecute(@Nonnull ProfileRequestContext prc) {
            super.doPostExecute(prc);
            throw new NullPointerException();
        }
    }

    private class ExecFailProfileAction
    extends BaseProfileAction {
        private ExecFailProfileAction() {
        }

        @Override
        protected void doExecute(@Nonnull ProfileRequestContext prc) {
            throw new RuntimeException();
        }

        @Override
        protected void doPostExecute(@Nonnull ProfileRequestContext prc) {
            throw new NullPointerException();
        }
    }

    private class PreFailProfileAction
    extends BaseProfileAction {
        private PreFailProfileAction() {
        }

        @Override
        protected boolean doPreExecute(@Nonnull ProfileRequestContext prc) {
            throw new RuntimeException();
        }
    }

    private class BaseProfileAction
    extends AbstractProfileAction {
        private boolean didPre = false;
        private boolean didExec = false;
        private boolean didPost = false;

        private BaseProfileAction() {
        }

        protected boolean doPreExecute(@Nonnull ProfileRequestContext prc) {
            this.didPre = true;
            return true;
        }

        protected void doExecute(@Nonnull ProfileRequestContext prc) {
            this.didExec = true;
        }

        protected void doPostExecute(@Nonnull ProfileRequestContext prc) {
            this.didPost = true;
        }
    }
}

