/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import java.util.Map;
import java.util.function.Supplier;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.spring.config.IdentifiableBeanPostProcessor;
import net.shibboleth.shared.spring.util.ApplicationContextBuilder;
import org.opensaml.profile.logic.IPRangePredicate;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IPRangePredicateTest {
    @Test
    public void testRanges() {
        GenericApplicationContext ctx = new ApplicationContextBuilder().setName("IpRange").setServiceConfiguration((Resource)new ClassPathResource("iprange.xml")).setBeanPostProcessor((BeanPostProcessor)new IdentifiableBeanPostProcessor()).build();
        Map map = ctx.getBeansOfType(IPRangePredicate.class);
        Assert.assertEquals((int)map.size(), (int)2);
        MockHttpServletRequest request = new MockHttpServletRequest();
        NonnullSupplier supplier = NonnullSupplier.of((Object)request);
        IPRangePredicate condition = (IPRangePredicate)map.get("three");
        condition.setHttpServletRequestSupplier((Supplier)supplier);
        request.setRemoteAddr("192.168.1.128");
        Assert.assertTrue((boolean)condition.test(null));
        request.setRemoteAddr("192.168.3.128");
        Assert.assertFalse((boolean)condition.test(null));
        request.setRemoteAddr("::1");
        Assert.assertFalse((boolean)condition.test(null));
        condition = (IPRangePredicate)map.get("four");
        condition.setHttpServletRequestSupplier((Supplier)supplier);
        request.setRemoteAddr("2620:df:8000:ff14:0:0:0:2");
        Assert.assertTrue((boolean)condition.test(null));
        request.setRemoteAddr("2620:df:8000:ff14:0:0:0:3");
        Assert.assertFalse((boolean)condition.test(null));
        request.setRemoteAddr("[2620:df:8000:ff14:0:0:0:2]");
        Assert.assertTrue((boolean)condition.test(null));
    }
}

