/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.profile.logic;

import javax.annotation.Nullable;

import org.opensaml.profile.context.ProfileRequestContext;

import java.util.function.Predicate;

/**
 * A predicate implementation that indicates whether the request is associated with a browser profile.
 */
public class BrowserProfilePredicate implements Predicate<ProfileRequestContext> {

    /** {@inheritDoc} */
    public boolean test(@Nullable final ProfileRequestContext input) {
        return input != null && input.isBrowserProfile();
    }
    
}