/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.criterion;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.saml.saml2.metadata.Endpoint;

public final class EndpointCriterion<EndpointType extends Endpoint>
implements Criterion {
    @Nonnull
    private final EndpointType endpoint;

    public EndpointCriterion(@Nonnull EndpointType ep) {
        this.endpoint = (Endpoint)Constraint.isNotNull(ep, (String)"Endpoint cannot be null");
    }

    @Nonnull
    public EndpointType getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EndpointCriterion [type=");
        builder.append(this.endpoint.getElementQName());
        if (this.endpoint.getBinding() != null) {
            builder.append(", Binding=");
            builder.append(this.endpoint.getBinding());
        }
        if (this.endpoint.getLocation() != null) {
            builder.append(", Location=");
            builder.append(this.endpoint.getLocation());
        }
        if (this.endpoint.getResponseLocation() != null) {
            builder.append(", ResponseLocation=");
        }
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EndpointCriterion) {
            EndpointType endpoint2 = ((EndpointCriterion)obj).getEndpoint();
            if (!Objects.equal((Object)this.endpoint.getElementQName(), (Object)endpoint2.getElementQName())) {
                return false;
            }
            if (!Objects.equal((Object)this.endpoint.getBinding(), (Object)endpoint2.getBinding())) {
                return false;
            }
            if (!Objects.equal((Object)this.endpoint.getLocation(), (Object)endpoint2.getLocation())) {
                return false;
            }
            return Objects.equal((Object)this.endpoint.getResponseLocation(), (Object)endpoint2.getResponseLocation());
        }
        return false;
    }
}

