/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding;

import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SAMLBindingSupportTest {
    @Test
    public void testConvertSAML2ArtifactEndpointIndex() {
        Assert.assertEquals((int)SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{0, 0}), (int)0);
        Assert.assertEquals((int)SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{0, 1}), (int)1);
        Assert.assertEquals((int)SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{0, 2}), (int)2);
        Assert.assertEquals((int)SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{0, 16}), (int)16);
        Assert.assertEquals((int)SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{0, -2}), (int)254);
        Assert.assertEquals((int)SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{0, -1}), (int)255);
        Assert.assertEquals((int)SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{127, -1}), (int)Short.MAX_VALUE);
        try {
            SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{-128, 0});
            Assert.fail((String)"Should have failed on input resulting in negative int");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLBindingSupport.convertSAML2ArtifactEndpointIndex(null);
            Assert.fail((String)"Should have failed on null input");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{2});
            Assert.fail((String)"Should have failed on too short input");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])new byte[]{0, 0, 2});
            Assert.fail((String)"Should have failed on too long input");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

