/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLMetadataLookupHandler
extends AbstractMessageHandler<SAMLObject> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLMetadataLookupHandler.class);
    @NonnullAfterInit
    private RoleDescriptorResolver metadataResolver;

    public void setRoleDescriptorResolver(@Nonnull RoleDescriptorResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataResolver = (RoleDescriptorResolver)Constraint.isNotNull((Object)resolver, (String)"RoleDescriptorResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataResolver == null) {
            throw new ComponentInitializationException("RoleDescriptorResolver cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext<SAMLObject> messageContext) throws MessageHandlerException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        SAMLPeerEntityContext peerCtx = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, false);
        SAMLProtocolContext protocolCtx = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class, false);
        if (peerCtx == null || peerCtx.getEntityId() == null || peerCtx.getRole() == null) {
            this.log.info("{} SAMLPeerEntityContext missing or did not contain an entityID or role", (Object)this.getLogPrefix());
            return;
        }
        EntityIdCriterion entityIdCriterion = new EntityIdCriterion(peerCtx.getEntityId());
        EntityRoleCriterion roleCriterion = new EntityRoleCriterion(peerCtx.getRole());
        ProtocolCriterion protocolCriterion = null;
        if (protocolCtx != null && protocolCtx.getProtocol() != null) {
            protocolCriterion = new ProtocolCriterion(protocolCtx.getProtocol());
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{entityIdCriterion, protocolCriterion, roleCriterion});
        try {
            RoleDescriptor roleMetadata = (RoleDescriptor)this.metadataResolver.resolveSingle((Object)criteria);
            if (roleMetadata == null) {
                if (protocolCriterion != null) {
                    this.log.info("{} No metadata returned for {} in role {} with protocol {}", new Object[]{this.getLogPrefix(), peerCtx.getEntityId(), peerCtx.getRole(), protocolCriterion.getProtocol()});
                } else {
                    this.log.info("{} No metadata returned for {} in role {}", new Object[]{this.getLogPrefix(), peerCtx.getEntityId(), peerCtx.getRole()});
                }
                return;
            }
            SAMLMetadataContext metadataCtx = new SAMLMetadataContext();
            metadataCtx.setEntityDescriptor((EntityDescriptor)roleMetadata.getParent());
            metadataCtx.setRoleDescriptor(roleMetadata);
            peerCtx.addSubcontext((BaseContext)metadataCtx);
            this.log.debug("{} {} added to MessageContext", (Object)this.getLogPrefix(), (Object)SAMLMetadataContext.class.getName());
        }
        catch (ResolverException e) {
            this.log.error(this.getLogPrefix() + " ResolverException thrown during metadata lookup", (Throwable)e);
        }
    }
}

