/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.messaging.impl.BaseTrustEngineSecurityHandler;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;

public abstract class BaseSAMLXMLSignatureSecurityHandler
extends BaseTrustEngineSecurityHandler<Signature, SAMLObject> {
    protected TrustEngine<Signature> resolveTrustEngine(MessageContext<SAMLObject> messageContext) {
        SecurityParametersContext secParams = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, false);
        if (secParams == null || secParams.getSignatureValidationParameters() == null) {
            return null;
        }
        return secParams.getSignatureValidationParameters().getSignatureTrustEngine();
    }

    @Nonnull
    protected CriteriaSet buildCriteriaSet(@Nullable String entityID, @Nonnull MessageContext<SAMLObject> messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!Strings.isNullOrEmpty((String)entityID)) {
            criteriaSet.add((Object)new EntityIdCriterion(entityID));
        }
        try {
            SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
            Constraint.isNotNull((Object)peerEntityContext, (String)"SAMLPeerEntityContext was null");
            Constraint.isNotNull((Object)peerEntityContext.getRole(), (String)"SAML peer role was null");
            criteriaSet.add((Object)new EntityRoleCriterion(peerEntityContext.getRole()));
            SAMLProtocolContext protocolContext = this.getSAMLProtocolContext(messageContext);
            Constraint.isNotNull((Object)protocolContext, (String)"SAMLProtocolContext was null");
            Constraint.isNotNull((Object)protocolContext.getProtocol(), (String)"SAML protocol was null");
            criteriaSet.add((Object)new ProtocolCriterion(protocolContext.getProtocol()));
        }
        catch (ConstraintViolationException e) {
            throw new MessageHandlerException((Exception)((Object)e));
        }
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        SecurityParametersContext secParamsContext = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class);
        if (secParamsContext != null && secParamsContext.getSignatureValidationParameters() != null) {
            criteriaSet.add((Object)new SignatureValidationParametersCriterion(secParamsContext.getSignatureValidationParameters()));
        }
        return criteriaSet;
    }

    protected SAMLProtocolContext getSAMLProtocolContext(@Nonnull MessageContext<SAMLObject> messageContext) {
        return (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class, false);
    }
}

