/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.DynamicMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicMetadataResolver
extends AbstractMetadataResolver
implements DynamicMetadataResolver {
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicMetadataResolver.class);
    private Timer taskTimer;
    private boolean createdOwnTaskTimer;
    private Long maxIdleEntityData;
    private Long cleanupTaskInterval;
    private BackingStoreCleanupSweeper cleanupTask;

    public AbstractDynamicMetadataResolver(@Nullable Timer backgroundTaskTimer) {
        if (backgroundTaskTimer == null) {
            this.taskTimer = new Timer(true);
            this.createdOwnTaskTimer = true;
        } else {
            this.taskTimer = backgroundTaskTimer;
        }
        this.cleanupTaskInterval = 1800000L;
        this.maxIdleEntityData = 28800000L;
    }

    @Nonnull
    public Long getMaxIdleEntityData() {
        return this.maxIdleEntityData;
    }

    public void setMaxIdleEntityData(@Nonnull Long max) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.maxIdleEntityData = (Long)Constraint.isNotNull((Object)max, (String)"Max idle entity data may not be null");
    }

    @Nonnull
    public Long getCleanupTaskInterval() {
        return this.cleanupTaskInterval;
    }

    public void setCleanupTaskInterval(@Nonnull Long interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.cleanupTaskInterval = (Long)Constraint.isNotNull((Object)interval, (String)"Cleanup task interval may not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        EntityIdCriterion entityIdCriterion = (EntityIdCriterion)criteria.get(EntityIdCriterion.class);
        if (entityIdCriterion == null || Strings.isNullOrEmpty((String)entityIdCriterion.getEntityId())) {
            throw new ResolverException("Entity Id was not supplied in criteria set");
        }
        String entityID = StringSupport.trimOrNull((String)((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        Lock readLock = this.getBackingStore().getManagementData(entityID).getReadWriteLock().readLock();
        try {
            readLock.lock();
            List<EntityDescriptor> descriptors = this.lookupEntityID(entityID);
            if (!descriptors.isEmpty()) {
                this.log.trace("Found requested metadata in backing store, returning");
                List<EntityDescriptor> list = descriptors;
                return list;
            }
        }
        finally {
            readLock.unlock();
        }
        this.log.trace("Did not find requested metadata in backing store, will attempt to fetch dynamically");
        return this.fetchByCriteria(criteria);
    }

    @Nonnull
    @NonnullElements
    protected abstract Iterable<EntityDescriptor> fetchByCriteria(@Nonnull CriteriaSet var1) throws ResolverException;

    @Override
    @Nonnull
    @NonnullElements
    protected List<EntityDescriptor> lookupEntityID(@Nonnull String entityID) throws ResolverException {
        this.getBackingStore().getManagementData(entityID).recordEntityAccess();
        return super.lookupEntityID(entityID);
    }

    @Nonnull
    protected void processNewMetadata(@Nonnull XMLObject root, @Nonnull String expectedEntityID) throws FilterException {
        XMLObject filteredMetadata = this.filterMetadata(root);
        if (filteredMetadata == null) {
            this.log.info("Metadata filtering process produced a null document, resulting in an empty data set");
            return;
        }
        if (filteredMetadata instanceof EntityDescriptor) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)filteredMetadata;
            if (!Objects.equals(entityDescriptor.getEntityID(), expectedEntityID)) {
                this.log.warn("New metadata's entityID '{}' does not match expected entityID '{}', will not process", (Object)entityDescriptor.getEntityID(), (Object)expectedEntityID);
                return;
            }
            this.preProcessEntityDescriptor(entityDescriptor, this.getBackingStore());
        } else {
            this.log.warn("Document root was not an EntityDescriptor: {}", (Object)root.getClass().getName());
        }
    }

    @Override
    @Nonnull
    protected DynamicEntityBackingStore createNewBackingStore() {
        return new DynamicEntityBackingStore();
    }

    @Override
    @NonnullAfterInit
    protected DynamicEntityBackingStore getBackingStore() {
        return (DynamicEntityBackingStore)super.getBackingStore();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        this.setBackingStore(this.createNewBackingStore());
        this.cleanupTask = new BackingStoreCleanupSweeper();
        this.taskTimer.schedule((TimerTask)this.cleanupTask, 60000L, (long)this.getCleanupTaskInterval());
    }

    @Override
    protected void doDestroy() {
        this.cleanupTask.cancel();
        if (this.createdOwnTaskTimer) {
            this.taskTimer.cancel();
        }
        this.cleanupTask = null;
        this.taskTimer = null;
        super.doDestroy();
    }

    protected class BackingStoreCleanupSweeper
    extends TimerTask {
        protected BackingStoreCleanupSweeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AbstractDynamicMetadataResolver.this.isDestroyed() || !AbstractDynamicMetadataResolver.this.isInitialized()) {
                return;
            }
            long now = System.currentTimeMillis();
            long latestValid = now - AbstractDynamicMetadataResolver.this.getMaxIdleEntityData();
            DynamicEntityBackingStore backingStore = AbstractDynamicMetadataResolver.this.getBackingStore();
            Map<String, List<EntityDescriptor>> indexedDescriptors = backingStore.getIndexedDescriptors();
            for (String entityID : indexedDescriptors.keySet()) {
                Lock writeLock = backingStore.getManagementData(entityID).getReadWriteLock().writeLock();
                try {
                    writeLock.lock();
                    if (backingStore.getManagementData(entityID).getLastAccessedTime() >= latestValid) continue;
                    indexedDescriptors.remove(entityID);
                    backingStore.removeManagementData(entityID);
                }
                finally {
                    writeLock.unlock();
                }
            }
            backingStore.cleanupOrphanedManagementData();
        }
    }

    protected class EntityManagementData {
        private long lastAccessedTime = System.currentTimeMillis();
        private ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);

        protected EntityManagementData() {
        }

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void recordEntityAccess() {
            long current = System.currentTimeMillis();
            if (current > this.lastAccessedTime) {
                this.lastAccessedTime = System.currentTimeMillis();
            }
        }

        public ReadWriteLock getReadWriteLock() {
            return this.readWriteLock;
        }
    }

    protected class DynamicEntityBackingStore
    extends AbstractMetadataResolver.EntityBackingStore {
        private Map<String, EntityManagementData> mgmtDataMap;

        protected DynamicEntityBackingStore() {
            super(AbstractDynamicMetadataResolver.this);
            this.mgmtDataMap = new ConcurrentHashMap<String, EntityManagementData>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public EntityManagementData getManagementData(@Nonnull String entityID) {
            Constraint.isNotNull((Object)entityID, (String)"EntityID may not be null");
            EntityManagementData entityData = this.mgmtDataMap.get(entityID);
            if (entityData != null) {
                return entityData;
            }
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                entityData = this.mgmtDataMap.get(entityID);
                if (entityData != null) {
                    return entityData;
                }
                entityData = new EntityManagementData();
                this.mgmtDataMap.put(entityID, entityData);
                return entityData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeManagementData(@Nonnull String entityID) {
            Constraint.isNotNull((Object)entityID, (String)"EntityID may not be null");
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                this.mgmtDataMap.remove(entityID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanupOrphanedManagementData() {
            for (String entityID : this.mgmtDataMap.keySet()) {
                Lock writeLock = this.mgmtDataMap.get(entityID).getReadWriteLock().writeLock();
                try {
                    writeLock.lock();
                    if (this.getIndexedDescriptors().containsKey(entityID)) continue;
                    this.removeManagementData(entityID);
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
    }
}

