/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.common.SAML2Support;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataResolver {
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataResolver.class);
    private UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    private boolean requireValidMetadata = true;
    private MetadataFilter mdFilter;
    private boolean failFastInitialization = true;
    private EntityBackingStore entityBackingStore;
    private ParserPool parser;

    public boolean isRequireValidMetadata() {
        return this.requireValidMetadata;
    }

    public void setRequireValidMetadata(boolean require) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.requireValidMetadata = require;
    }

    @Nullable
    public MetadataFilter getMetadataFilter() {
        return this.mdFilter;
    }

    public void setMetadataFilter(@Nullable MetadataFilter newFilter) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.mdFilter = newFilter;
    }

    public boolean isFailFastInitialization() {
        return this.failFastInitialization;
    }

    public void setFailFastInitialization(boolean failFast) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.failFastInitialization = failFast;
    }

    @Nonnull
    public ParserPool getParserPool() {
        return this.parser;
    }

    public void setParserPool(@Nonnull ParserPool pool) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.parser = (ParserPool)Constraint.isNotNull((Object)pool, (String)"ParserPool may not be null");
    }

    @Nullable
    public EntityDescriptor resolveSingle(CriteriaSet criteria) throws ResolverException {
        Iterator iterator;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Iterable iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return (EntityDescriptor)iterator.next();
        }
        return null;
    }

    protected UnmarshallerFactory getUnmarshallerFactory() {
        return this.unmarshallerFactory;
    }

    protected final void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.initMetadataResolver();
        }
        catch (ComponentInitializationException e) {
            if (this.failFastInitialization) {
                this.log.error("Metadata provider failed to properly initialize, fail-fast=true, halting", (Throwable)e);
                throw e;
            }
            this.log.error("Metadata provider failed to properly initialize, fail-fast=false, continuing on in a degraded state", (Throwable)e);
        }
    }

    protected void doDestroy() {
        this.unmarshallerFactory = null;
        this.mdFilter = null;
        this.entityBackingStore = null;
        this.parser = null;
        super.doDestroy();
    }

    protected void initMetadataResolver() throws ComponentInitializationException {
    }

    @Nonnull
    protected XMLObject unmarshallMetadata(@Nonnull InputStream metadataInput) throws UnmarshallingException {
        try {
            XMLObject metadata;
            if (this.parser == null) {
                throw new UnmarshallingException("ParserPool is null, can't parse input stream");
            }
            this.log.trace("Parsing retrieved metadata into a DOM object");
            Document mdDocument = this.parser.parse(metadataInput);
            this.log.trace("Unmarshalling and caching metdata DOM");
            Unmarshaller unmarshaller = this.getUnmarshallerFactory().getUnmarshaller(mdDocument.getDocumentElement());
            if (unmarshaller == null) {
                String msg = "No unmarshaller registered for document element " + QNameSupport.getNodeQName((Node)mdDocument.getDocumentElement());
                this.log.error(msg);
                throw new UnmarshallingException(msg);
            }
            XMLObject xMLObject = metadata = unmarshaller.unmarshall(mdDocument.getDocumentElement());
            return xMLObject;
        }
        catch (Exception e) {
            throw new UnmarshallingException(e);
        }
        finally {
            try {
                metadataInput.close();
            }
            catch (IOException e2) {
                this.log.debug("Failed to close input: {}", (Throwable)e2);
            }
        }
    }

    @Nullable
    protected XMLObject filterMetadata(@Nullable XMLObject metadata) throws FilterException {
        if (this.getMetadataFilter() != null) {
            this.log.debug("Applying metadata filter");
            return this.getMetadataFilter().filter(metadata);
        }
        return metadata;
    }

    protected void releaseMetadataDOM(@Nullable XMLObject metadata) {
        if (metadata != null) {
            metadata.releaseDOM();
            metadata.releaseChildrenDOM(true);
        }
    }

    protected boolean isValid(@Nullable XMLObject descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (!this.isRequireValidMetadata()) {
            return true;
        }
        return SAML2Support.isValid((XMLObject)descriptor);
    }

    @Nonnull
    @NonnullElements
    protected List<EntityDescriptor> lookupEntityID(@Nonnull @NotEmpty String entityID) throws ResolverException {
        if (!this.isInitialized()) {
            throw new ResolverException("Metadata resolver has not been initialized");
        }
        if (Strings.isNullOrEmpty((String)entityID)) {
            this.log.debug("EntityDescriptor entityID was null or empty, skipping search for it");
            return Collections.emptyList();
        }
        List<EntityDescriptor> descriptors = this.lookupIndexedEntityID(entityID);
        if (descriptors.isEmpty()) {
            this.log.debug("Metadata backing store does not contain any EntityDescriptors with the ID: {}", (Object)entityID);
            return descriptors;
        }
        Iterator<EntityDescriptor> entitiesIter = descriptors.iterator();
        while (entitiesIter.hasNext()) {
            EntityDescriptor descriptor = entitiesIter.next();
            if (this.isValid((XMLObject)descriptor)) continue;
            this.log.debug("Metadata backing store contained an EntityDescriptor with the ID: {},  but it was no longer valid", (Object)entityID);
            entitiesIter.remove();
        }
        return descriptors;
    }

    @Nonnull
    @NonnullElements
    protected List<EntityDescriptor> lookupIndexedEntityID(@Nonnull @NotEmpty String entityID) {
        List<EntityDescriptor> descriptors = this.getBackingStore().getIndexedDescriptors().get(entityID);
        if (descriptors != null) {
            return new ArrayList<EntityDescriptor>(descriptors);
        }
        return Collections.emptyList();
    }

    @Nonnull
    protected EntityBackingStore createNewBackingStore() {
        return new EntityBackingStore();
    }

    @Nonnull
    protected EntityBackingStore getBackingStore() {
        return this.entityBackingStore;
    }

    protected void setBackingStore(@Nonnull EntityBackingStore newBackingStore) {
        this.entityBackingStore = (EntityBackingStore)Constraint.isNotNull((Object)newBackingStore, (String)"EntityBackingStore may not be null");
    }

    protected void preProcessEntityDescriptor(@Nonnull EntityDescriptor entityDescriptor, @Nonnull EntityBackingStore backingStore) {
        backingStore.getOrderedDescriptors().add(entityDescriptor);
        this.indexEntityDescriptor(entityDescriptor, backingStore);
    }

    protected void indexEntityDescriptor(@Nonnull EntityDescriptor entityDescriptor, @Nonnull EntityBackingStore backingStore) {
        String entityID = StringSupport.trimOrNull((String)entityDescriptor.getEntityID());
        if (entityID != null) {
            List<EntityDescriptor> entities = backingStore.getIndexedDescriptors().get(entityID);
            if (entities == null) {
                entities = new ArrayList<EntityDescriptor>();
                backingStore.getIndexedDescriptors().put(entityID, entities);
            } else if (!entities.isEmpty()) {
                this.log.warn("Detected duplicate EntityDescriptor for entityID: {}", (Object)entityID);
            }
            entities.add(entityDescriptor);
        }
    }

    protected void preProcessEntitiesDescriptor(@Nonnull EntitiesDescriptor entitiesDescriptor, EntityBackingStore backingStore) {
        for (XMLObject child : entitiesDescriptor.getOrderedChildren()) {
            if (child instanceof EntityDescriptor) {
                this.preProcessEntityDescriptor((EntityDescriptor)child, backingStore);
                continue;
            }
            if (!(child instanceof EntitiesDescriptor)) continue;
            this.preProcessEntitiesDescriptor((EntitiesDescriptor)child, backingStore);
        }
    }

    protected class EntityBackingStore {
        private Map<String, List<EntityDescriptor>> indexedDescriptors = new ConcurrentHashMap<String, List<EntityDescriptor>>();
        private List<EntityDescriptor> orderedDescriptors = new ArrayList<EntityDescriptor>();

        protected EntityBackingStore() {
        }

        @Nonnull
        public Map<String, List<EntityDescriptor>> getIndexedDescriptors() {
            return this.indexedDescriptors;
        }

        @Nonnull
        public List<EntityDescriptor> getOrderedDescriptors() {
            return this.orderedDescriptors;
        }
    }
}

