/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.artifact.impl;

import java.io.IOException;
import java.time.Duration;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.binding.artifact.impl.StorageServiceSAMLArtifactMap;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class StorageServiceSAMLArtifactMapTest
extends XMLObjectBaseTestCase {
    private MemoryStorageService storageService;
    private StorageServiceSAMLArtifactMap artifactMap;
    private String artifact = "the-artifact";
    private String issuerId = "urn:test:issuer";
    private String rpId = "urn:test:rp";
    private SAMLObject samlObject;
    private Element origElement;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.samlObject = (SAMLObject)this.unmarshallElement("/org/opensaml/saml/saml2/core/ResponseSuccessAuthnAttrib.xml");
        this.origElement = this.samlObject.getDOM();
        this.samlObject.releaseChildrenDOM(true);
        this.samlObject.releaseDOM();
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.initialize();
        this.artifactMap = new StorageServiceSAMLArtifactMap();
        this.artifactMap.setStorageService((StorageService)this.storageService);
        this.artifactMap.setArtifactLifetime(Duration.ofMinutes(5L));
        this.artifactMap.initialize();
    }

    @Test
    public void testBasicPutGet() throws IOException, MarshallingException {
        Assert.assertFalse((boolean)this.artifactMap.contains(this.artifact));
        this.artifactMap.put(this.artifact, this.rpId, this.issuerId, this.samlObject);
        Assert.assertTrue((boolean)this.artifactMap.contains(this.artifact));
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(this.artifact);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((String)entry.getArtifact(), (String)this.artifact, (String)"Invalid value for artifact");
        Assert.assertEquals((String)entry.getIssuerId(), (String)this.issuerId, (String)"Invalid value for issuer ID");
        Assert.assertEquals((String)entry.getRelyingPartyId(), (String)this.rpId, (String)"Invalid value for relying party ID");
        SAMLObject retrievedObject = entry.getSamlMessage();
        Element newElement = marshallerFactory.getMarshaller((XMLObject)retrievedObject).marshall((XMLObject)retrievedObject);
        Diff diff = DiffBuilder.compare((Object)this.origElement).withTest((Object)newElement).checkForIdentical().ignoreWhitespace().build();
        Assert.assertFalse((boolean)diff.hasDifferences(), (String)diff.toString());
    }

    @Test
    public void testRemove() throws IOException {
        Assert.assertFalse((boolean)this.artifactMap.contains(this.artifact));
        this.artifactMap.put(this.artifact, this.rpId, this.issuerId, this.samlObject);
        Assert.assertTrue((boolean)this.artifactMap.contains(this.artifact));
        this.artifactMap.remove(this.artifact);
        Assert.assertFalse((boolean)this.artifactMap.contains(this.artifact));
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(this.artifact);
        Assert.assertNull((Object)entry, (String)"Entry was removed");
    }

    @Test
    public void testEntryExpiration() throws Exception {
        this.artifactMap = new StorageServiceSAMLArtifactMap();
        this.artifactMap.setStorageService((StorageService)this.storageService);
        this.artifactMap.setArtifactLifetime(Duration.ofSeconds(1L));
        this.artifactMap.initialize();
        Assert.assertFalse((boolean)this.artifactMap.contains(this.artifact));
        this.artifactMap.put(this.artifact, this.rpId, this.issuerId, this.samlObject);
        Assert.assertTrue((boolean)this.artifactMap.contains(this.artifact));
        Thread.sleep(3000L);
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(this.artifact);
        Assert.assertNull((Object)entry, (String)"Entry should have expired");
    }
}

