/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import java.time.Duration;
import java.time.Instant;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.security.impl.MessageLifetimeSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MessageLifetimeSecurityHandlerTest
extends XMLObjectBaseTestCase {
    private MessageContext messageContext;
    private MessageLifetimeSecurityHandler handler;
    private Duration clockSkew;
    private Duration messageLifetime;
    private Instant now;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.now = Instant.now();
        this.clockSkew = Duration.ofMinutes(5L);
        this.messageLifetime = Duration.ofMinutes(10L);
        this.messageContext = new MessageContext();
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now);
        this.handler = new MessageLifetimeSecurityHandler();
        this.handler.setClockSkew(this.clockSkew);
        this.handler.setMessageLifetime(this.messageLifetime);
        this.handler.initialize();
    }

    @Test
    public void testValid() throws MessageHandlerException {
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidIssuedInFuture() throws MessageHandlerException {
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now.plus(this.clockSkew).plusSeconds(5L));
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testValidIssuedInFutureWithinClockSkew() throws MessageHandlerException {
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now.plus(this.clockSkew).minusSeconds(5L));
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidExpired() throws MessageHandlerException {
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now.minus(this.messageLifetime.plus(this.clockSkew).plusSeconds(5L)));
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testValidExpiredWithinClockSkew() throws MessageHandlerException {
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(this.now.minus(this.messageLifetime.plus(this.clockSkew).minusSeconds(5L)));
        this.handler.invoke(this.messageContext);
    }
}

