/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.security.impl.ReceivedEndpointSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReceivedEndpointSecurityHandlerTest
extends XMLObjectBaseTestCase {
    private MessageContext messageContext;
    private SAMLBindingContext samlBindingContext;
    private MockHttpServletRequest httpRequest;
    private String intendedDestinationUri;
    private ReceivedEndpointSecurityHandler handler;

    @BeforeMethod
    public void setUp() throws MessageException, ComponentInitializationException {
        this.messageContext = new MessageContext();
        this.messageContext.setMessage((Object)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest.xml"));
        this.httpRequest = new MockHttpServletRequest();
        this.samlBindingContext = (SAMLBindingContext)this.messageContext.getSubcontext(SAMLBindingContext.class, true);
        this.samlBindingContext.setBindingUri("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        this.samlBindingContext.setHasBindingSignature(false);
        this.samlBindingContext.setIntendedDestinationEndpointURIRequired(false);
        this.intendedDestinationUri = SAMLBindingSupport.getIntendedDestinationEndpointURI((MessageContext)this.messageContext);
        this.handler = new ReceivedEndpointSecurityHandler();
        this.handler.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.handler.initialize();
    }

    @Test
    public void testEndpointGood() throws MessageHandlerException {
        String deliveredEndpointURL = this.intendedDestinationUri;
        this.populateRequestURL(this.httpRequest, deliveredEndpointURL);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testEndpointInvalidPath() throws MessageHandlerException {
        String deliveredEndpointURL = this.intendedDestinationUri + "/some/other/endpointURI";
        this.populateRequestURL(this.httpRequest, deliveredEndpointURL);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testEndpointInvalidHost() throws MessageHandlerException {
        String deliveredEndpointURL = "https://bogusidp.example.com/idp/sso";
        this.populateRequestURL(this.httpRequest, deliveredEndpointURL);
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testEndpointMissingDestinationNotRequired() throws MessageHandlerException {
        AuthnRequest authnRequest = (AuthnRequest)this.messageContext.getMessage();
        authnRequest.setDestination(null);
        this.samlBindingContext.setIntendedDestinationEndpointURIRequired(false);
        String deliveredEndpointURL = this.intendedDestinationUri;
        this.populateRequestURL(this.httpRequest, deliveredEndpointURL);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testEndpointMissingDestinationRequired() throws MessageHandlerException {
        AuthnRequest authnRequest = (AuthnRequest)this.messageContext.getMessage();
        authnRequest.setDestination(null);
        this.samlBindingContext.setIntendedDestinationEndpointURIRequired(true);
        String deliveredEndpointURL = this.intendedDestinationUri;
        this.populateRequestURL(this.httpRequest, deliveredEndpointURL);
        this.handler.invoke(this.messageContext);
    }

    private void populateRequestURL(MockHttpServletRequest request, String requestURL) {
        URL url = null;
        try {
            url = new URL(requestURL);
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Malformed URL: " + e.getMessage()));
        }
        request.setScheme(url.getProtocol());
        request.setServerName(url.getHost());
        if (url.getPort() != -1) {
            request.setServerPort(url.getPort());
        } else if ("https".equalsIgnoreCase(url.getProtocol())) {
            request.setServerPort(443);
        } else if ("http".equalsIgnoreCase(url.getProtocol())) {
            request.setServerPort(80);
        }
        request.setRequestURI(url.getPath());
        request.setQueryString(url.getQuery());
    }
}

