/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.messaging.context.tests;

import java.time.Instant;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.testing.TestContext;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SAMLMessageInfoContextTest
extends XMLObjectBaseTestCase {
    private String id;
    private Instant issueInstant;

    @BeforeClass
    public void setUp() {
        this.id = "abc123";
        this.issueInstant = Instant.now();
    }

    @Test
    public void testNoParent() {
        SAMLMessageInfoContext infoContext = new SAMLMessageInfoContext();
        Assert.assertNull((Object)infoContext.getMessageId());
        Assert.assertNull((Object)infoContext.getMessageIssueInstant());
    }

    @Test
    public void testNonMessageContextParent() {
        TestContext testContext = new TestContext();
        SAMLMessageInfoContext infoContext = (SAMLMessageInfoContext)testContext.getSubcontext(SAMLMessageInfoContext.class, true);
        Assert.assertNull((Object)infoContext.getMessageId());
        Assert.assertNull((Object)infoContext.getMessageIssueInstant());
    }

    @Test
    public void testNonSAMLMessage() {
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage(new Object());
        SAMLMessageInfoContext infoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true);
        Assert.assertNull((Object)infoContext.getMessageId());
        Assert.assertNull((Object)infoContext.getMessageIssueInstant());
    }

    @Test
    public void testSAML2Request() {
        MessageContext messageContext = new MessageContext();
        AuthnRequest message = (AuthnRequest)this.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        message.setID(this.id);
        message.setIssueInstant(this.issueInstant);
        messageContext.setMessage((Object)message);
        SAMLMessageInfoContext infoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true);
        Assert.assertEquals((String)infoContext.getMessageId(), (String)this.id);
        Assert.assertEquals((Object)infoContext.getMessageIssueInstant(), (Object)this.issueInstant);
    }

    @Test
    public void testSAML2Response() {
        MessageContext messageContext = new MessageContext();
        org.opensaml.saml.saml2.core.Response message = (org.opensaml.saml.saml2.core.Response)this.buildXMLObject(org.opensaml.saml.saml2.core.Response.DEFAULT_ELEMENT_NAME);
        message.setID(this.id);
        message.setIssueInstant(this.issueInstant);
        messageContext.setMessage((Object)message);
        SAMLMessageInfoContext infoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true);
        Assert.assertEquals((String)infoContext.getMessageId(), (String)this.id);
        Assert.assertEquals((Object)infoContext.getMessageIssueInstant(), (Object)this.issueInstant);
    }

    @Test
    public void testSAML1Request() {
        MessageContext messageContext = new MessageContext();
        Request message = (Request)this.buildXMLObject(Request.DEFAULT_ELEMENT_NAME);
        message.setID(this.id);
        message.setIssueInstant(this.issueInstant);
        messageContext.setMessage((Object)message);
        SAMLMessageInfoContext infoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true);
        Assert.assertEquals((String)infoContext.getMessageId(), (String)this.id);
        Assert.assertEquals((Object)infoContext.getMessageIssueInstant(), (Object)this.issueInstant);
    }

    @Test
    public void testSAML1Response() {
        MessageContext messageContext = new MessageContext();
        Response message = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        message.setID(this.id);
        message.setIssueInstant(this.issueInstant);
        messageContext.setMessage((Object)message);
        SAMLMessageInfoContext infoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true);
        Assert.assertEquals((String)infoContext.getMessageId(), (String)this.id);
        Assert.assertEquals((Object)infoContext.getMessageIssueInstant(), (Object)this.issueInstant);
    }
}

