/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.messaging.context.ChannelBindingsContext;
import org.opensaml.saml.common.profile.impl.VerifyChannelBindings;
import org.opensaml.saml.ext.saml2cb.ChannelBindings;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class VerifyChannelBindingsTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private VerifyChannelBindings action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new VerifyChannelBindings();
        this.action.initialize();
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
    }

    @Test
    public void testNoBindings() throws MessageHandlerException {
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)this.prc.getSubcontext(ChannelBindingsContext.class));
    }

    @Test
    public void testMatch() throws MessageHandlerException {
        ChannelBindings cb = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setType("foo");
        cb.setValue("foo");
        ((ChannelBindingsContext)this.prc.getInboundMessageContext().getSubcontext(ChannelBindingsContext.class, true)).getChannelBindings().add(cb);
        ((ChannelBindingsContext)((SOAP11Context)this.prc.getInboundMessageContext().getSubcontext(SOAP11Context.class, true)).getSubcontext(ChannelBindingsContext.class, true)).getChannelBindings().add(cb);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        ChannelBindingsContext cbCtx = (ChannelBindingsContext)this.prc.getOutboundMessageContext().getSubcontext(ChannelBindingsContext.class);
        Assert.assertNotNull((Object)cbCtx);
        Assert.assertEquals((int)cbCtx.getChannelBindings().size(), (int)1);
        ChannelBindings[] array = cbCtx.getChannelBindings().toArray(new ChannelBindings[1]);
        Assert.assertTrue((boolean)"foo".equals(array[0].getValue()));
    }

    @Test
    public void testNoMatch() throws MessageHandlerException {
        ChannelBindings cb = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setType("foo");
        cb.setValue("foo");
        ChannelBindings cb2 = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setType("bar");
        cb.setValue("foo");
        ((ChannelBindingsContext)this.prc.getInboundMessageContext().getSubcontext(ChannelBindingsContext.class, true)).getChannelBindings().add(cb);
        ((ChannelBindingsContext)((SOAP11Context)this.prc.getInboundMessageContext().getSubcontext(SOAP11Context.class, true)).getSubcontext(ChannelBindingsContext.class, true)).getChannelBindings().add(cb2);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"ChannelBindingsError");
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getSubcontext(ChannelBindingsContext.class));
    }

    @Test
    public void testNoMatch2() throws MessageHandlerException {
        ChannelBindings cb = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setType("foo");
        cb.setValue("foo");
        ((ChannelBindingsContext)this.prc.getInboundMessageContext().getSubcontext(ChannelBindingsContext.class, true)).getChannelBindings().add(cb);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"ChannelBindingsError");
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getSubcontext(ChannelBindingsContext.class));
    }
}

