/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic.tests;

import java.util.Arrays;
import java.util.Collections;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.common.profile.logic.EntityGroupNamePredicate;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.EntitiesDescriptorNameProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EntityGroupNamePredicateTest
extends XMLObjectBaseTestCase {
    private NodeProcessingMetadataFilter filter;
    private ResourceBackedMetadataResolver metadataProvider;

    @BeforeClass
    protected void setUp() throws Exception {
        ClassPathResource resource = new ClassPathResource("/org/opensaml/saml/metadata/resolver/filter/impl/EntitiesDescriptor-Name-metadata.xml");
        this.filter = new NodeProcessingMetadataFilter();
        this.filter.setNodeProcessors(Collections.singletonList(new EntitiesDescriptorNameProcessor()));
        this.filter.initialize();
        this.metadataProvider = new ResourceBackedMetadataResolver(null, ResourceHelper.of((Resource)resource));
        this.metadataProvider.setId("test");
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setMetadataFilter((MetadataFilter)this.filter);
        this.metadataProvider.initialize();
    }

    @AfterClass
    protected void tearDown() {
        this.metadataProvider.destroy();
        this.filter.destroy();
    }

    @Test
    public void testNoMatch() throws Exception {
        EntityGroupNamePredicate condition = new EntityGroupNamePredicate(Collections.singletonList("GroupBad"), (MetadataResolver)this.metadataProvider);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)condition.test(entity));
    }

    @Test
    public void testGroupMatch() throws Exception {
        EntityGroupNamePredicate condition = new EntityGroupNamePredicate(Collections.singletonList("GroupTop"), (MetadataResolver)this.metadataProvider);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)condition.test(entity));
    }

    @Test
    public void testGroupsMatch() throws Exception {
        EntityGroupNamePredicate condition = new EntityGroupNamePredicate(Arrays.asList("GroupBad", "GroupSub2"), (MetadataResolver)this.metadataProvider);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub2a.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)condition.test(entity));
    }

    @Test
    public void testAffiliationMatch() throws Exception {
        EntityGroupNamePredicate condition = new EntityGroupNamePredicate(Collections.singletonList("https://affiliation.example.org"), (MetadataResolver)this.metadataProvider);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub2a.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)condition.test(entity));
    }

    @Test
    public void testAffiliationNoMatch() throws Exception {
        EntityGroupNamePredicate condition = new EntityGroupNamePredicate(Collections.singletonList("https://affiliation.example.org"), (MetadataResolver)this.metadataProvider);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)condition.test(entity));
    }
}

