/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdrpi.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdrpi.Publication;
import org.opensaml.saml.ext.saml2mdrpi.PublicationPath;
import org.testng.Assert;

public class PublicationPathTest
extends XMLObjectProviderBaseTestCase {
    private static String[] publishers = new String[]{"pub1", "pub2"};

    public PublicationPathTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdrpi/PublicationPath.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2mdrpi/PublicationPathChildren.xml";
    }

    public void testSingleElementUnmarshall() {
        PublicationPath pPath = (PublicationPath)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((int)pPath.getPublications().size(), (int)0);
    }

    public void testSingleElementMarshall() {
        PublicationPath pPath = (PublicationPath)this.buildXMLObject(PublicationPath.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)pPath);
    }

    public void testChildElementsUnmarshall() {
        PublicationPath pPath = (PublicationPath)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)pPath.getPublications().size(), (int)2);
        Publication pub = (Publication)pPath.getPublications().get(0);
        Assert.assertEquals((String)pub.getPublisher(), (String)publishers[0]);
        pub = (Publication)pPath.getPublications().get(1);
        Assert.assertEquals((String)pub.getPublisher(), (String)publishers[1]);
    }

    public void testChildElementsMarshall() {
        PublicationPath pPath = (PublicationPath)this.buildXMLObject(PublicationPath.DEFAULT_ELEMENT_NAME);
        for (int i = 0; i < 2; ++i) {
            Publication pub = (Publication)this.buildXMLObject(Publication.DEFAULT_ELEMENT_NAME);
            pub.setPublisher(publishers[i]);
            pPath.getPublications().add(pub);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)pPath);
    }
}

