/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdui.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.saml.ext.saml2mdui.DiscoHints;
import org.opensaml.saml.ext.saml2mdui.DomainHint;
import org.opensaml.saml.ext.saml2mdui.GeolocationHint;
import org.opensaml.saml.ext.saml2mdui.IPHint;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DiscoHintsTest
extends XMLObjectProviderBaseTestCase {
    private final int expectedIPHintCount = 2;
    private final int expectedDomainHintsCount = 3;
    private final int expectedGeolocationHintsCount = 1;
    private final int expectedSimpleElementCount = 1;

    public DiscoHintsTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdui/DiscoHints.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2mdui/DiscoHintsChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        DiscoHints hints = (DiscoHints)this.unmarshallElement(this.singleElementFile);
        hints.toString();
    }

    @Test
    public void testSingleElementMarshall() {
        DiscoHints hints = (DiscoHints)this.buildXMLObject(DiscoHints.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)hints);
    }

    @Test
    public void testChildElementsUnmarshall() {
        DiscoHints hints = (DiscoHints)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)hints.getIPHints().size(), (int)2, (String)"<IPHint> count");
        Assert.assertEquals((int)hints.getDomainHints().size(), (int)3, (String)"<DomainHint> count");
        Assert.assertEquals((int)hints.getGeolocationHints().size(), (int)1, (String)"<GeolocationHint> count");
        Assert.assertEquals((int)hints.getXMLObjects(SimpleXMLObject.ELEMENT_NAME).size(), (int)1, (String)"<test:SimpleElement> count");
    }

    @Test
    public void testChildElementsMarshall() {
        DiscoHints hints = (DiscoHints)this.buildXMLObject(DiscoHints.DEFAULT_ELEMENT_NAME);
        hints.getDomainHints().add((DomainHint)this.buildXMLObject(DomainHint.DEFAULT_ELEMENT_NAME));
        hints.getIPHints().add((IPHint)this.buildXMLObject(IPHint.DEFAULT_ELEMENT_NAME));
        hints.getGeolocationHints().add((GeolocationHint)this.buildXMLObject(GeolocationHint.DEFAULT_ELEMENT_NAME));
        hints.getXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        hints.getDomainHints().add((DomainHint)this.buildXMLObject(DomainHint.DEFAULT_ELEMENT_NAME));
        hints.getIPHints().add((IPHint)this.buildXMLObject(IPHint.DEFAULT_ELEMENT_NAME));
        hints.getDomainHints().add((DomainHint)this.buildXMLObject(DomainHint.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)hints);
    }
}

