/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.AlgorithmFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolverTest;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.xmlsec.encryption.MGF;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AlgorithmFilterTest
extends XMLObjectBaseTestCase
implements Predicate<EntityDescriptor> {
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;

    @BeforeMethod
    protected void setUp() throws Exception {
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/metadata/resolver/filter/impl/EntityDescriptorWithAlgorithms.xml");
        this.mdFile = new File(mdURL.toURI());
        this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
        this.metadataProvider.setParserPool(parserPool);
    }

    @Test
    public void test() throws ComponentInitializationException, ResolverException {
        DigestMethod digest1 = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digest1.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        DigestMethod digest2 = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digest2.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
        DigestMethod digest3 = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digest3.setAlgorithm("foo");
        SigningMethod signing1 = (SigningMethod)this.buildXMLObject(SigningMethod.DEFAULT_ELEMENT_NAME);
        signing1.setAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        SigningMethod signing2 = (SigningMethod)this.buildXMLObject(SigningMethod.DEFAULT_ELEMENT_NAME);
        signing2.setAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        SigningMethod signing3 = (SigningMethod)this.buildXMLObject(SigningMethod.DEFAULT_ELEMENT_NAME);
        signing3.setAlgorithm("foo");
        EncryptionMethod enc1 = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        enc1.setAlgorithm("http://www.w3.org/2009/xmlenc11#rsa-oaep");
        org.opensaml.xmlsec.signature.DigestMethod embeddedDigest = (org.opensaml.xmlsec.signature.DigestMethod)this.buildXMLObject(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
        embeddedDigest.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        enc1.getUnknownXMLObjects().add(embeddedDigest);
        MGF mgf = (MGF)this.buildXMLObject(MGF.DEFAULT_ELEMENT_NAME);
        mgf.setAlgorithm("http://www.w3.org/2009/xmlenc11#mgf1sha256");
        enc1.getUnknownXMLObjects().add(mgf);
        EncryptionMethod enc2 = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        enc2.setAlgorithm("foo");
        EncryptionMethod enc3 = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        enc3.setAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        List<EncryptionMethod> algs = List.of(digest1, digest2, signing1, signing2, enc1, digest3, signing3, enc2, enc3);
        AlgorithmFilter filter = new AlgorithmFilter();
        filter.setRules(Collections.singletonMap(this, algs));
        filter.initialize();
        this.metadataProvider.setMetadataFilter((MetadataFilter)filter);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        EntityIdCriterion crit = new EntityIdCriterion("https://foo.example.org/sp");
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{crit}));
        Assert.assertNotNull((Object)entity);
        Extensions exts = entity.getExtensions();
        Assert.assertNotNull((Object)exts);
        List extElements = exts.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME);
        Assert.assertEquals((int)extElements.size(), (int)3);
        Iterator digests = extElements.iterator();
        Assert.assertEquals((String)((DigestMethod)digests.next()).getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((String)((DigestMethod)digests.next()).getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((String)((DigestMethod)digests.next()).getAlgorithm(), (String)"foo");
        extElements = exts.getUnknownXMLObjects(SigningMethod.DEFAULT_ELEMENT_NAME);
        Assert.assertEquals((int)extElements.size(), (int)3);
        Iterator signings = extElements.iterator();
        Assert.assertEquals((String)((SigningMethod)signings.next()).getAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)((SigningMethod)signings.next()).getAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        Assert.assertEquals((String)((SigningMethod)signings.next()).getAlgorithm(), (String)"foo");
        for (RoleDescriptor role : entity.getRoleDescriptors()) {
            for (KeyDescriptor key : role.getKeyDescriptors()) {
                List methods = key.getEncryptionMethods();
                Assert.assertEquals((int)methods.size(), (int)3);
                Assert.assertEquals((String)((EncryptionMethod)methods.get(0)).getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                Assert.assertEquals((String)((EncryptionMethod)methods.get(1)).getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#rsa-oaep");
                Assert.assertEquals((String)((EncryptionMethod)methods.get(2)).getAlgorithm(), (String)"foo");
                List encDigests = ((EncryptionMethod)methods.get(1)).getUnknownXMLObjects(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
                Assert.assertEquals((int)encDigests.size(), (int)1);
                Assert.assertEquals((String)((org.opensaml.xmlsec.signature.DigestMethod)encDigests.get(0)).getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
                List mgfs = ((EncryptionMethod)methods.get(1)).getUnknownXMLObjects(MGF.DEFAULT_ELEMENT_NAME);
                Assert.assertEquals((int)mgfs.size(), (int)1);
                Assert.assertEquals((String)((MGF)mgfs.get(0)).getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha256");
            }
        }
    }

    @Override
    public boolean test(EntityDescriptor input) {
        return input.getEntityID().equals("https://foo.example.org/sp");
    }
}

